/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.policies;

import io.apiman.gateway.engine.IServiceConnection;
import io.apiman.gateway.engine.IServiceConnectionResponse;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.test.policies.IPolicyTestBackEndService;
import io.apiman.test.policies.PolicyTestBackEndServiceResponse;
import io.apiman.test.policies.PolicyTesterServiceConnectionResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PolicyTesterServiceConnection
implements IServiceConnection {
    private final ServiceRequest request;
    private final IAsyncResultHandler<IServiceConnectionResponse> handler;
    private ByteArrayOutputStream output;
    private final IPolicyTestBackEndService backEndService;
    private boolean finished;

    private static IPolicyTestBackEndService createBackEndService(String endpoint) {
        try {
            Class<?> theClass = Class.forName(endpoint);
            return (IPolicyTestBackEndService)theClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PolicyTesterServiceConnection(Service service, ServiceRequest request, IAsyncResultHandler<IServiceConnectionResponse> handler) {
        this.request = request;
        this.handler = handler;
        this.output = null;
        this.backEndService = PolicyTesterServiceConnection.createBackEndService(service.getEndpoint());
    }

    public void write(IApimanBuffer chunk) {
        if (this.output == null) {
            this.output = new ByteArrayOutputStream();
        }
        try {
            this.output.write(chunk.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void end() {
        PolicyTestBackEndServiceResponse response = this.backEndService.invoke(this.request, this.output == null ? null : this.output.toByteArray());
        PolicyTesterServiceConnectionResponse connectionResponse = new PolicyTesterServiceConnectionResponse(response);
        this.handler.handle((Object)AsyncResultImpl.create((Object)connectionResponse));
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isConnected() {
        return !this.isFinished();
    }

    public void abort() {
        this.finished = true;
    }
}

