/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.modules.Module;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BootstrapBundlesInstallPlugin;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.CoreServices;
import org.jboss.osgi.framework.internal.FrameworkActive;
import org.jboss.osgi.framework.internal.FrameworkCreate;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkInit;
import org.jboss.osgi.framework.internal.FrameworkProxy;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.PersistentBundlesInstallPlugin;
import org.jboss.osgi.framework.internal.SecurityActions;
import org.jboss.osgi.framework.internal.SystemBundlePlugin;
import org.jboss.osgi.framework.internal.SystemContextPlugin;
import org.jboss.osgi.framework.internal.URLHandlerPlugin;
import org.jboss.osgi.framework.spi.BundleLifecyclePlugin;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.BundleStoragePlugin;
import org.jboss.osgi.framework.spi.DeploymentProviderPlugin;
import org.jboss.osgi.framework.spi.EnvironmentPlugin;
import org.jboss.osgi.framework.spi.FrameworkBuilder;
import org.jboss.osgi.framework.spi.FrameworkModuleLoaderPlugin;
import org.jboss.osgi.framework.spi.FrameworkModuleProviderPlugin;
import org.jboss.osgi.framework.spi.IntegrationService;
import org.jboss.osgi.framework.spi.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.spi.LockManagerPlugin;
import org.jboss.osgi.framework.spi.ModuleManagerPlugin;
import org.jboss.osgi.framework.spi.NativeCodePlugin;
import org.jboss.osgi.framework.spi.PackageAdminPlugin;
import org.jboss.osgi.framework.spi.ResolverPlugin;
import org.jboss.osgi.framework.spi.ServiceManagerPlugin;
import org.jboss.osgi.framework.spi.StartLevelPlugin;
import org.jboss.osgi.framework.spi.SystemPathsPlugin;
import org.jboss.osgi.framework.spi.SystemServicesPlugin;
import org.osgi.framework.launch.Framework;

public final class FrameworkBuilderImpl
implements FrameworkBuilder {
    private final Map<String, Object> initialProperties = new HashMap<String, Object>();
    private final Map<FrameworkBuilder.FrameworkPhase, Map<ServiceName, IntegrationService<?>>> integrationServices;
    private final ServiceController.Mode initialMode;
    private ServiceContainer serviceContainer;
    private ServiceTarget serviceTarget;
    private boolean closed;

    public FrameworkBuilderImpl(Map<String, Object> props, ServiceController.Mode initialMode) {
        this.initialMode = initialMode;
        this.integrationServices = new HashMap();
        if (props != null) {
            this.initialProperties.putAll(props);
        }
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object value = this.initialProperties.get(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.initialProperties);
    }

    @Override
    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    @Override
    public void setServiceContainer(ServiceContainer serviceContainer) {
        this.assertNotClosed();
        this.serviceContainer = serviceContainer;
    }

    @Override
    public ServiceContainer createServiceContainer() {
        Object maxThreads = this.getProperty("org.jboss.osgi.framework.bootstrap.maxThreads");
        if (maxThreads == null) {
            maxThreads = SecurityActions.getSystemProperty("org.jboss.osgi.framework.bootstrap.maxThreads", null);
        }
        if (maxThreads != null) {
            return ServiceContainer.Factory.create((int)new Integer("" + maxThreads), (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        return ServiceContainer.Factory.create();
    }

    @Override
    public ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public void setServiceTarget(ServiceTarget serviceTarget) {
        this.assertNotClosed();
        this.serviceTarget = serviceTarget;
    }

    @Override
    public ServiceController.Mode getInitialMode() {
        return this.initialMode;
    }

    @Override
    public Framework createFramework() {
        this.assertNotClosed();
        return new FrameworkProxy(this);
    }

    @Override
    public void registerIntegrationService(FrameworkBuilder.FrameworkPhase phase, IntegrationService<?> service) {
        this.assertNotClosed();
        Map<ServiceName, IntegrationService<?>> phaseServices = this.integrationServices.get((Object)phase);
        if (phaseServices == null) {
            phaseServices = new HashMap();
            this.integrationServices.put(phase, phaseServices);
        }
        phaseServices.put(service.getServiceName(), service);
    }

    @Override
    public BundleManager createFrameworkServices(ServiceContainer serviceContainer, boolean firstInit) {
        this.integrationServices.clear();
        this.closed = false;
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new URLHandlerPlugin());
        if (this.getProperty(ModuleLogger.class.getName()) == null) {
            Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
        }
        BundleManagerPlugin bundleManager = new BundleManagerPlugin(serviceContainer, this);
        FrameworkState frameworkState = new FrameworkState(bundleManager);
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, bundleManager);
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new FrameworkCreate(frameworkState, this.initialMode));
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new BundleLifecyclePlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new FrameworkModuleProviderPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new FrameworkModuleLoaderPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new StartLevelPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new SystemPathsPlugin(this));
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new SystemServicesPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new CoreServices());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new FrameworkEventsPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new BundleStoragePlugin(firstInit));
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new DeploymentProviderPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new EnvironmentPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new LifecycleInterceptorPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new LockManagerPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new ModuleManagerPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new NativeCodePlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new PackageAdminPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new ResolverPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new ServiceManagerPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new SystemBundlePlugin(frameworkState));
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, new SystemContextPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.INIT, new FrameworkInit(this.initialMode));
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.INIT, new BootstrapBundlesInstallPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.INIT, new PersistentBundlesInstallPlugin());
        this.registerIntegrationService(FrameworkBuilder.FrameworkPhase.ACTIVE, new FrameworkActive(this.initialMode));
        return bundleManager;
    }

    @Override
    public void installServices(FrameworkBuilder.FrameworkPhase phase, ServiceTarget serviceTarget, ServiceListener<Object> listener) {
        this.assertNotClosed();
        Map<ServiceName, IntegrationService<?>> phaseServices = this.integrationServices.get((Object)phase);
        for (IntegrationService<?> service : phaseServices.values()) {
            service.install(serviceTarget, listener);
        }
        FrameworkBuilder.FrameworkPhase[] phases = FrameworkBuilder.FrameworkPhase.values();
        if (phase == phases[phases.length - 1]) {
            this.closed = true;
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkBuilderClosed();
        }
    }
}

