/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class RaRemove
implements OperationStepHandler {
    static final RaRemove INSTANCE = new RaRemove();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        final String name = PathAddress.pathAddress((ModelNode)opAddr).getLastElement().getValue();
        final ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        final String archiveOrModuleName = model.get(Constants.ARCHIVE.getName()).isDefined() ? Constants.ARCHIVE.resolveModelAttribute(context, model).asString() : Constants.MODULE.resolveModelAttribute(context, model).asString();
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        if (model.hasDefined("resource-adapters")) {
            for (ModelNode raNode : model.get("resource-adapters").asList()) {
                ModelNode raCompensatingNode = raNode.clone();
                compensating.get("resource-adapters").add(raCompensatingNode);
            }
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final boolean wasActive = RaOperationUtil.deactivateIfActive(context, name);
                ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{name});
                ServiceController serviceController = context.getServiceRegistry(false).getService(raServiceName);
                final ModifiableResourceAdapter resourceAdapter = serviceController != null ? (ModifiableResourceAdapter)((Object)serviceController.getValue()) : null;
                List serviceNameList = context.getServiceRegistry(false).getServiceNames();
                for (ServiceName name2 : serviceNameList) {
                    if (!raServiceName.isParentOf(name2)) continue;
                    context.removeService(name2);
                }
                if (model.get(Constants.MODULE.getName()).isDefined()) {
                    ServiceName deployerServiceName = ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{name});
                    context.removeService(deployerServiceName);
                    ServiceName inactiveServiceName = ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{name});
                    context.removeService(inactiveServiceName);
                }
                context.removeService(raServiceName);
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        if (resourceAdapter != null) {
                            LinkedList newControllers = new LinkedList();
                            if (model.get(Constants.ARCHIVE.getName()).isDefined()) {
                                RaOperationUtil.installRaServices(context, new ServiceVerificationHandler(), name, resourceAdapter, newControllers);
                            } else {
                                try {
                                    RaOperationUtil.installRaServicesAndDeployFromModule(context, new ServiceVerificationHandler(), name, resourceAdapter, archiveOrModuleName, newControllers);
                                }
                                catch (OperationFailedException e) {
                                    // empty catch block
                                }
                            }
                            try {
                                if (wasActive) {
                                    RaOperationUtil.activate(context, archiveOrModuleName, archiveOrModuleName, null);
                                }
                            }
                            catch (OperationFailedException e) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

