/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.ClientMapping;
import org.jboss.ejb.client.remoting.ClusterNode;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionClusterNodeManager;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.MessageInputStream;

class ClusterTopologyMessageHandler
extends ProtocolMessageHandler {
    private static final Logger logger = Logger.getLogger(ClusterTopologyMessageHandler.class);
    private final ChannelAssociation channelAssociation;
    private final boolean completeTopology;

    ClusterTopologyMessageHandler(ChannelAssociation channelAssociation, boolean completeTopology) {
        this.channelAssociation = channelAssociation;
        this.completeTopology = completeTopology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(MessageInputStream messageInputStream) throws IOException {
        Collection<ClusterNode> nodes;
        if (messageInputStream == null) {
            throw new IllegalArgumentException("Cannot read from null stream");
        }
        HashMap clusterNodes = new HashMap();
        try {
            DataInputStream input = new DataInputStream(messageInputStream);
            int clusterCount = PackedInteger.readPackedInteger(input);
            for (int i = 0; i < clusterCount; ++i) {
                String clusterName = input.readUTF();
                int clusterMemberCount = PackedInteger.readPackedInteger(input);
                nodes = new ArrayList();
                for (int j = 0; j < clusterMemberCount; ++j) {
                    String nodeName = input.readUTF();
                    int clientMappingCount = PackedInteger.readPackedInteger(input);
                    ClientMapping[] clientMappings = new ClientMapping[clientMappingCount];
                    for (int c = 0; c < clientMappingCount; ++c) {
                        int netMaskWithIPFamilyDifferentiator = PackedInteger.readPackedInteger(input);
                        int ipFamilyDifferentiator = netMaskWithIPFamilyDifferentiator & 1;
                        int clientNetMask = netMaskWithIPFamilyDifferentiator >> 1;
                        byte[] clientNetworkAddressBytes = ipFamilyDifferentiator == 0 ? new byte[16] : new byte[4];
                        input.readFully(clientNetworkAddressBytes);
                        InetAddress clientNetworkAddress = InetAddress.getByAddress(clientNetworkAddressBytes);
                        String destinationAddress = input.readUTF();
                        short destinationPort = input.readShort();
                        clientMappings[c] = new ClientMapping(clientNetworkAddress, clientNetMask & 0xFF, destinationAddress, destinationPort);
                    }
                    ClusterNode clusterNode = new ClusterNode(clusterName, nodeName, clientMappings);
                    nodes.add(clusterNode);
                }
                clusterNodes.put(clusterName, nodes);
            }
        }
        finally {
            messageInputStream.close();
        }
        EJBReceiverContext ejbReceiverContext = this.channelAssociation.getEjbReceiverContext();
        EJBClientContext clientContext = ejbReceiverContext.getClientContext();
        for (Map.Entry entry : clusterNodes.entrySet()) {
            String clusterName = (String)entry.getKey();
            nodes = (Collection)entry.getValue();
            logger.debug("Received a cluster node(s) addition message, for cluster named " + clusterName + " with " + nodes.size() + " nodes " + Arrays.toString(nodes.toArray()));
            ClusterContext clusterContext = clientContext.getOrCreateClusterContext(clusterName);
            this.addNodesToClusterContext(clusterContext, nodes);
        }
    }

    private void addNodesToClusterContext(ClusterContext clusterContext, Collection<ClusterNode> clusterNodes) {
        Endpoint endpoint = this.channelAssociation.getChannel().getConnection().getEndpoint();
        EJBClientConfiguration ejbClientConfiguration = clusterContext.getEJBClientContext().getEJBClientConfiguration();
        ClusterNodeManager[] clusterNodeManagers = new ClusterNodeManager[clusterNodes.size()];
        int i = 0;
        for (ClusterNode clusterNode : clusterNodes) {
            clusterNodeManagers[i++] = new RemotingConnectionClusterNodeManager(clusterContext, clusterNode, endpoint, ejbClientConfiguration);
        }
        clusterContext.addClusterNodes(clusterNodeManagers);
    }
}

