/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.core.client.transport.NettyClient;

public abstract class HTTPRemotingConnection
implements RemoteConnection {
    private boolean closed;
    private Integer chunkSize;

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public SOAPMessage invoke(SOAPMessage reqMessage, Object endpoint, boolean oneway) throws IOException {
        String[] transferEncodingValue;
        String targetAddress;
        if (endpoint == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("endpoint");
        }
        if (this.closed) {
            throw NativeMessages.MESSAGES.connectionAlreadyClosed();
        }
        Map<Object, Object> callProps = new HashMap();
        if (endpoint instanceof EndpointInfo) {
            EndpointInfo epInfo = (EndpointInfo)endpoint;
            targetAddress = epInfo.getTargetAddress();
            callProps = epInfo.getProperties();
        } else {
            targetAddress = endpoint.toString();
        }
        String[] stringArray = transferEncodingValue = reqMessage != null ? reqMessage.getMimeHeaders().getHeader("Transfer-Encoding") : null;
        if (transferEncodingValue != null && "disabled".equals(transferEncodingValue[0])) {
            reqMessage.getMimeHeaders().removeHeader("Transfer-Encoding");
            callProps.put("http://org.jboss.ws/http#chunksize", 0);
        }
        NettyClient client = new NettyClient(this.getMarshaller(), this.getUnmarshaller());
        if (this.chunkSize != null) {
            client.setChunkSize(this.chunkSize);
        }
        HashMap<String, Object> additionalHeaders = new HashMap<String, Object>();
        this.populateHeaders(reqMessage, additionalHeaders);
        MessageTrace.traceMessage("Outgoing Request Message", reqMessage);
        SOAPMessage resMessage = (SOAPMessage)client.invoke(reqMessage, targetAddress, oneway, additionalHeaders, callProps);
        MessageTrace.traceMessage("Incoming Response Message", resMessage);
        return resMessage;
    }

    protected void populateHeaders(SOAPMessage reqMessage, Map<String, Object> metadata) {
        if (reqMessage != null) {
            MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader header = (MimeHeader)i.next();
                String hName = header.getName();
                Object currentValue = metadata.get(hName);
                if (currentValue != null) {
                    metadata.put(hName, currentValue + "," + header.getValue());
                    continue;
                }
                metadata.put(hName, header.getValue());
            }
        }
    }
}

