/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import org.jboss.ws.NativeMessages;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.RemoteConnection;

public class RemoteConnectionFactory {
    public RemoteConnection getRemoteConnection(EndpointInfo epInfo) {
        String targetAddress = epInfo.getTargetAddress();
        if (targetAddress == null) {
            throw NativeMessages.MESSAGES.cannotObtainTargetAddressFrom(epInfo);
        }
        String key = null;
        if ((targetAddress = targetAddress.toLowerCase()).startsWith("http")) {
            key = RemoteConnection.class.getName() + ".http";
        }
        if (key == null) {
            throw NativeMessages.MESSAGES.cannotObtainRemoteConnectionFor(targetAddress);
        }
        RemoteConnection con = (RemoteConnection)ServiceLoader.loadService(key, null, (ClassLoader)this.getClass().getClassLoader());
        if (con == null) {
            throw NativeMessages.MESSAGES.cannotObtainRemoteConnectionFor(key);
        }
        return con;
    }
}

