/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.io.IOException;
import java.util.Map;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.core.client.HTTPRemotingConnection;
import org.jboss.ws.core.client.Marshaller;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.core.soap.SOAPMessageMarshaller;
import org.jboss.ws.core.soap.SOAPMessageUnMarshallerHTTP;

public class SOAPProtocolConnectionHTTP
extends HTTPRemotingConnection {
    @Override
    public UnMarshaller getUnmarshaller() {
        return new SOAPMessageUnMarshallerHTTP();
    }

    @Override
    public Marshaller getMarshaller() {
        return new SOAPMessageMarshaller();
    }

    @Override
    public SOAPMessage invoke(SOAPMessage reqMessage, Object endpoint, boolean oneway) throws IOException {
        try {
            SOAPMessage soapMessage = reqMessage;
            if (reqMessage != null && soapMessage.saveRequired()) {
                soapMessage.saveChanges();
            }
            return super.invoke(reqMessage, endpoint, oneway);
        }
        catch (SOAPException ex) {
            IOException io = new IOException();
            io.initCause(ex);
            throw io;
        }
    }

    @Override
    protected void populateHeaders(SOAPMessage reqMessage, Map<String, Object> metadata) {
        super.populateHeaders(reqMessage, metadata);
        if (reqMessage != null) {
            MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
            String[] action = mimeHeaders.getHeader("SOAPAction");
            if (action != null && action.length > 0) {
                String soapAction = action[0];
                if (!soapAction.startsWith("\"") || !soapAction.endsWith("\"")) {
                    soapAction = "\"" + soapAction + "\"";
                }
                metadata.put("SOAPAction", soapAction);
            } else {
                metadata.put("SOAPAction", "\"\"");
            }
        }
    }
}

