/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.repository.RepositoryResolutionException;
import org.jboss.osgi.repository.URLResourceBuilderFactory;
import org.jboss.osgi.repository.spi.AbstractRepository;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

final class ModuleIdentityRepository
extends AbstractRepository {
    private final File modulesDir;
    private final File bundlesDir;

    ModuleIdentityRepository(ServerEnvironment serverEnvironment) {
        this.bundlesDir = serverEnvironment.getBundlesDir();
        if (!this.bundlesDir.isDirectory()) {
            throw OSGiMessages.MESSAGES.illegalStateArtifactBaseLocation(this.bundlesDir);
        }
        this.modulesDir = new File(this.bundlesDir.getParent() + File.separator + "modules");
        if (!this.modulesDir.isDirectory()) {
            throw OSGiMessages.MESSAGES.illegalStateArtifactBaseLocation(this.modulesDir);
        }
    }

    public Collection<Capability> findProviders(Requirement req) {
        String namespace = req.getNamespace();
        ArrayList<XCapability> result = new ArrayList<XCapability>();
        if ("module.identity".equals(namespace)) {
            String moduleId = (String)req.getAttributes().get("module.identity");
            ModuleIdentifier moduleIdentifier = ModuleIdentifier.fromString((String)moduleId);
            try {
                File contentFile = ModuleIdentityRepository.getRepositoryEntry(this.bundlesDir, moduleIdentifier);
                if (contentFile == null) {
                    contentFile = ModuleIdentityRepository.getRepositoryEntry(this.modulesDir, moduleIdentifier);
                }
                if (contentFile != null) {
                    URL contentURL = contentFile.toURI().toURL();
                    XResourceBuilder builder = URLResourceBuilderFactory.create((URL)contentURL, null, (boolean)true);
                    XCapability cap = builder.addCapability("module.identity", moduleId);
                    builder.getResource();
                    result.add(cap);
                }
            }
            catch (RepositoryResolutionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RepositoryResolutionException((Throwable)ex);
            }
        }
        return Collections.unmodifiableList(result);
    }

    static File getRepositoryEntry(File rootDir, ModuleIdentifier identifier) throws IOException {
        String identifierPath = identifier.getName().replace('.', '/') + "/" + identifier.getSlot();
        File entryDir = new File(rootDir + "/" + identifierPath);
        if (!entryDir.isDirectory()) {
            OSGiLogger.LOGGER.tracef("Cannot obtain directory: %s", entryDir);
            return null;
        }
        String[] files = entryDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files.length == 0) {
            OSGiLogger.LOGGER.tracef("Cannot find jar in: %s", entryDir);
            return null;
        }
        if (files.length > 1) {
            OSGiLogger.LOGGER.tracef("Multiple jars in: %s", entryDir);
            return null;
        }
        File entryFile = new File(entryDir + "/" + files[0]);
        if (!entryFile.exists()) {
            OSGiLogger.LOGGER.tracef("File does not exist: %s", entryFile);
            return null;
        }
        return entryFile;
    }
}

