/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.AbstractBundleRevisionAdaptor;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XBundleRevisionBuilderFactory;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.osgi.framework.BundleContext;

public class ModuleRegistrationTracker
extends AbstractService<Void> {
    public static final ServiceName MODULE_REGISTRATION_COMPLETE = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"module", "registration"});
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final Map<Module, Registration> registrations = new LinkedHashMap<Module, Registration>();

    public ServiceController<Void> install(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        ServiceBuilder builder = serviceTarget.addService(MODULE_REGISTRATION_COMPLETE, (Service)this);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependencies(new ServiceName[]{IntegrationServices.BOOTSTRAP_BUNDLES_COMPLETE});
        builder.addListener((ServiceListener)verificationHandler);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    public synchronized void registerModule(Module module, OSGiMetaData metadata) {
        BundleContext context = (BundleContext)this.injectedSystemContext.getOptionalValue();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getOptionalValue();
        Registration reg = new Registration(module, metadata);
        if (context != null && env != null) {
            this.registerInternal(context, env, reg);
        }
        this.registrations.put(module, reg);
    }

    public synchronized void unregisterModule(Module module) {
        BundleContext context = (BundleContext)this.injectedSystemContext.getOptionalValue();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getOptionalValue();
        Registration reg = this.registrations.remove(module);
        if (context != null && env != null && reg != null) {
            this.unregisterInternal(env, reg);
        }
    }

    public synchronized void start(StartContext startContext) throws StartException {
        ServiceController serviceController = startContext.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", serviceController.getName(), serviceController.getMode());
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (Registration reg : this.registrations.values()) {
            this.registerInternal(syscontext, env, reg);
        }
        this.registrations.clear();
    }

    private XBundleRevision registerInternal(final BundleContext context, XEnvironment env, Registration reg) {
        OSGiMetaData metadata = reg.metadata;
        final Module module = reg.module;
        OSGiLogger.LOGGER.infoRegisterModule(module.getIdentifier());
        XBundleRevisionBuilderFactory factory = new XBundleRevisionBuilderFactory(){

            public XBundleRevision createResource() {
                return new AbstractBundleRevisionAdaptor(context, module);
            }
        };
        try {
            XResourceBuilder builder = XBundleRevisionBuilderFactory.create((XBundleRevisionBuilderFactory)factory);
            if (metadata != null) {
                builder.loadFrom(metadata);
            } else {
                builder.loadFrom(module);
            }
            reg.brev = (XBundleRevision)builder.getResource();
            env.installResources(new XResource[]{reg.brev});
        }
        catch (Throwable th) {
            throw OSGiMessages.MESSAGES.illegalStateFailedToRegisterModule(th, module);
        }
        return reg.brev;
    }

    private void unregisterInternal(XEnvironment env, Registration reg) {
        assert (reg.brev != null) : "BundleRevision not null";
        OSGiLogger.LOGGER.infoUnregisterModule(reg.module.getIdentifier());
        env.uninstallResources(new XResource[]{reg.brev});
    }

    public static final class Registration {
        private final OSGiMetaData metadata;
        private final Module module;
        private XBundleRevision brev;

        Registration(Module module, OSGiMetaData metadata) {
            this.metadata = metadata;
            this.module = module;
        }
    }
}

