/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.reflect;

import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;

public final class DeploymentReflectionIndex {
    private final Map<Class<?>, ClassReflectionIndex<?>> classes = new HashMap();
    private static final Permission DEPLOYMENT_REFLECTION_INDEX_PERMISSION = new RuntimePermission("createDeploymentReflectionIndex");

    DeploymentReflectionIndex() {
    }

    public static DeploymentReflectionIndex create() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(DEPLOYMENT_REFLECTION_INDEX_PERMISSION);
        }
        return new DeploymentReflectionIndex();
    }

    public synchronized <T> ClassReflectionIndex<T> getClassIndex(Class<T> clazz) {
        try {
            ClassReflectionIndex<Object> index = this.classes.get(clazz);
            if (index == null) {
                index = new ClassReflectionIndex<T>(clazz, this);
                this.classes.put(clazz, index);
            }
            return index;
        }
        catch (Throwable e) {
            throw ServerMessages.MESSAGES.errorGettingReflectiveInformation(clazz, clazz.getClassLoader(), e);
        }
    }
}

