/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContext;
import org.apache.catalina.core.StandardContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.WebDeploymentService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class WebContextLifecycleInterceptor
extends AbstractLifecycleInterceptor
implements Service<LifecycleInterceptor> {
    static final ServiceName SERVICE_NAME = WebSubsystemServices.JBOSS_WEB.append(new String[]{WebContextLifecycleInterceptor.class.getSimpleName()});
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private ServiceRegistration registration;

    WebContextLifecycleInterceptor() {
    }

    static ServiceController<LifecycleInterceptor> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        WebContextLifecycleInterceptor service = new WebContextLifecycleInterceptor();
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, service.injectedSystemContext);
        builder.addListener((ServiceListener)verificationHandler);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    public void start(StartContext context) throws StartException {
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = syscontext.registerService(LifecycleInterceptor.class.getName(), (Object)this, null);
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public void invoke(int state, InvocationContext context) {
        XBundle bundle = (XBundle)context.getBundle();
        XBundleRevision brev = bundle.getBundleRevision();
        WebDeploymentService.ContextActivator activator = (WebDeploymentService.ContextActivator)brev.getAttachment(WebDeploymentService.ContextActivator.class);
        if (activator != null) {
            switch (state) {
                case 32: {
                    try {
                        this.injectBundleContext(activator.getContext(), bundle.getBundleContext());
                        if (!activator.start(4L, TimeUnit.SECONDS)) {
                            throw new LifecycleInterceptorException(WebMessages.MESSAGES.startContextFailed());
                        }
                        break;
                    }
                    catch (TimeoutException ex) {
                        throw new LifecycleInterceptorException(ex.getMessage(), (Throwable)ex);
                    }
                }
                case 4: {
                    activator.stop(4L, TimeUnit.SECONDS);
                    this.uninjectBundleContext(activator.getContext());
                }
            }
        }
    }

    private void injectBundleContext(StandardContext webContext, BundleContext bundleContext) {
        WebLogger.WEB_LOGGER.debugf("Injecting bundle context %s into %s", (Object)bundleContext, (Object)webContext);
        ServletContext servletContext = webContext.getServletContext();
        servletContext.setAttribute("osgi-bundlecontext", (Object)bundleContext);
        this.registerServletContextService(servletContext, bundleContext);
    }

    private void uninjectBundleContext(StandardContext webContext) {
        WebLogger.WEB_LOGGER.debugf("Uninjecting bundle context from %s", (Object)webContext);
        ServletContext servletContext = webContext.getServletContext();
        servletContext.removeAttribute("osgi-bundlecontext");
    }

    private void registerServletContextService(ServletContext servletContext, BundleContext bundleContext) {
        Object contextPath;
        Bundle bundle = bundleContext.getBundle();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.web.symbolicname", bundle.getSymbolicName());
        Dictionary headers = bundle.getHeaders();
        Object version = headers.get("Bundle-Version");
        if (version instanceof String) {
            ((Dictionary)props).put("osgi.web.version", (String)version);
        }
        if ((contextPath = headers.get("Web-ContextPath")) instanceof String) {
            ((Dictionary)props).put("osgi.web.contextpath", (String)contextPath);
        }
        bundleContext.registerService(ServletContext.class.getName(), (Object)servletContext, props);
    }

    public LifecycleInterceptor getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

