/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.ConnectorServiceDefinition;
import org.jboss.as.messaging.CoreAddressDefinition;
import org.jboss.as.messaging.DiscoveryGroupDefinition;
import org.jboss.as.messaging.DivertDefinition;
import org.jboss.as.messaging.GenericTransportDefinition;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.HornetQServerResourceDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.Messaging12SubsystemParser;
import org.jboss.as.messaging.Messaging13SubsystemParser;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.as.messaging.MessagingSubsystemRootResourceDefinition;
import org.jboss.as.messaging.MessagingTransformers;
import org.jboss.as.messaging.MessagingXMLWriter;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.messaging.SecuritySettingDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.JMSQueueDefinition;
import org.jboss.as.messaging.jms.JMSTopicDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class MessagingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "messaging";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"messaging");
    static final String RESOURCE_NAME = MessagingExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    public static final ModelVersion VERSION_1_2_0 = ModelVersion.create((int)1, (int)2, (int)0);
    public static final ModelVersion VERSION_1_1_0 = ModelVersion.create((int)1, (int)1, (int)0);

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        return MessagingExtension.getResourceDescriptionResolver(true, keyPrefix);
    }

    public static ResourceDescriptionResolver getResourceDescriptionResolver(boolean useUnprefixedChildTypes, String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder();
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, useUnprefixedChildTypes);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        subsystem.registerXMLElementWriter((XMLElementWriter)MessagingXMLWriter.INSTANCE);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        ManagementResourceRegistration rootRegistration = subsystem.registerSubsystemModel((ResourceDefinition)MessagingSubsystemRootResourceDefinition.INSTANCE);
        rootRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration serverRegistration = rootRegistration.registerSubModel((ResourceDefinition)new HornetQServerResourceDefinition(registerRuntimeOnly));
        if (registerRuntimeOnly) {
            ManagementResourceRegistration coreAddress = serverRegistration.registerSubModel((ResourceDefinition)new CoreAddressDefinition());
            coreAddress.setRuntimeOnly(true);
        }
        serverRegistration.registerSubModel((ResourceDefinition)new AddressSettingDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new BroadcastGroupDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new DiscoveryGroupDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new DivertDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)QueueDefinition.newQueueDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)QueueDefinition.newRuntimeQueueDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)GenericTransportDefinition.createAcceptorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)RemoteTransportDefinition.createAcceptorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)InVMTransportDefinition.createAcceptorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)GenericTransportDefinition.createConnectorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)RemoteTransportDefinition.createConnectorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)InVMTransportDefinition.createConnectorDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new BridgeDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new ClusterConnectionDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new GroupingHandlerDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new ConnectorServiceDefinition(registerRuntimeOnly));
        for (String path : MessagingPathHandlers.PATHS.keySet()) {
            ManagementResourceRegistration bindings = serverRegistration.registerSubModel(PathElement.pathElement((String)"path", (String)path), (DescriptionProvider)new MessagingSubsystemProviders.PathProvider(path));
            MessagingPathHandlers.register(bindings, path);
            if (!context.getProcessType().isServer()) continue;
            ResolvePathHandler resolvePathHandler = ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)MessagingPathHandlers.PATHS.get(path)).setRelativeToAttribute((AttributeDefinition)MessagingPathHandlers.RELATIVE_TO).build();
            bindings.registerOperationHandler(resolvePathHandler.getOperationDefinition(), (OperationStepHandler)resolvePathHandler);
        }
        serverRegistration.registerSubModel((ResourceDefinition)new ConnectionFactoryDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new PooledConnectionFactoryDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new JMSQueueDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new JMSTopicDefinition(registerRuntimeOnly));
        serverRegistration.registerSubModel((ResourceDefinition)new SecuritySettingDefinition(registerRuntimeOnly));
        if (registerRuntimeOnly) {
            SimpleResourceDefinition deploymentsDef = new SimpleResourceDefinition(SUBSYSTEM_PATH, MessagingExtension.getResourceDescriptionResolver("deployed"));
            ManagementResourceRegistration deploymentsRegistration = subsystem.registerDeploymentModel((ResourceDefinition)deploymentsDef);
            ManagementResourceRegistration serverModel = deploymentsRegistration.registerSubModel((ResourceDefinition)new HornetQServerResourceDefinition(true));
            serverModel.registerSubModel((ResourceDefinition)JMSQueueDefinition.newDeployedJMSQueueDefinition());
            serverModel.registerSubModel((ResourceDefinition)JMSTopicDefinition.newDeployedJMSTopicDefinition());
        }
        rootRegistration.registerSubModel((ResourceDefinition)new JMSBridgeDefinition());
        if (context.isRegisterTransformers()) {
            MessagingTransformers.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_0.getUriString(), (XMLElementReader)MessagingSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_1.getUriString(), (XMLElementReader)MessagingSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_2.getUriString(), (XMLElementReader)Messaging12SubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_3.getUriString(), (XMLElementReader)Messaging13SubsystemParser.getInstance());
    }
}

