/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.net.Socket;
import org.jacorb.config.Configuration;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.util.threadpool.Consumer;
import org.omg.ETF.Connection;
import org.slf4j.Logger;

public class MessageReceptor
implements Consumer {
    private final Logger logger;
    private final boolean enhanceThreadName;

    public MessageReceptor(Configuration configuration) {
        this.logger = configuration.getLogger("jacorb.orb.giop");
        this.enhanceThreadName = configuration.getAttributeAsBoolean("jacorb.enhanced_thread_name", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(Object job) {
        try {
            String oldName;
            GIOPConnection connection = (GIOPConnection)job;
            if (this.enhanceThreadName) {
                oldName = Thread.currentThread().getName();
                Connection transport = connection.getTransport();
                String enhancedName = this.getEnhancedName(transport, oldName);
                Thread.currentThread().setName(enhancedName);
            } else {
                oldName = null;
            }
            try {
                connection.receiveMessages();
            }
            finally {
                if (this.enhanceThreadName) {
                    Thread.currentThread().setName(oldName);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("unexpected exception during doWork", (Throwable)e);
        }
    }

    private String getEnhancedName(Connection transport, String oldName) {
        if (transport instanceof ServerIIOPConnection) {
            Socket socket = ((ServerIIOPConnection)transport).getSocket();
            int localPort = socket.getLocalPort();
            int port = socket.getPort();
            StringBuffer buffer = new StringBuffer();
            buffer.append(oldName);
            buffer.append('[');
            buffer.append(localPort);
            buffer.append(socket.getInetAddress().toString());
            buffer.append(':');
            buffer.append(port);
            buffer.append("] [");
            buffer.append(System.currentTimeMillis());
            buffer.append(']');
            return buffer.toString();
        }
        return oldName;
    }
}

