/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.interceptor;

import java.util.logging.Logger;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.impl.AddressingPropertiesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    static final Logger LOG = LogUtils.getL7dLogger(SCTOutInterceptor.class);

    public SCTOutInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        AddressingProperties inProps = (AddressingProperties)message.getContextualProperty("javax.xml.ws.addressing.context.inbound");
        AddressingProperties outProps = (AddressingProperties)message.getContextualProperty("javax.xml.ws.addressing.context.outbound");
        if (inProps != null) {
            if (outProps == null) {
                outProps = new AddressingPropertiesImpl(inProps.getNamespaceURI());
            }
            AttributedURIType action = new AttributedURIType();
            action.setValue(inProps.getAction().getValue().replace("/RST/", "/RSTR/"));
            outProps.setAction(action);
            message.put("javax.xml.ws.addressing.context.outbound", (Object)outProps);
        }
    }
}

