/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityCreator {
    private static Log logger = LogFactory.getLog(EntityCreator.class);

    public static Object buildFromDoc(String fileName, String thePackage) throws JAXBException, IOException {
        Object obj = null;
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        if (url == null) {
            logger.error((Object)("Could not find resource: " + fileName));
        } else {
            InputStream resourceStream = url.openStream();
            JAXBContext jc = JAXBContext.newInstance((String)thePackage);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            obj = ((JAXBElement)unmarshaller.unmarshal(resourceStream)).getValue();
        }
        return obj;
    }

    public static Object buildFromString(String source, String thePackage) throws JAXBException, IOException {
        JAXBElement obj = null;
        JAXBContext jc = JAXBContext.newInstance((String)thePackage);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        obj = (JAXBElement)unmarshaller.unmarshal((Reader)new StringReader(source));
        return obj;
    }

    public static void outputEntity(Object obj, String thePackage) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)thePackage);
        Marshaller marshaller = jc.createMarshaller();
        marshaller.marshal((Object)new JAXBElement(new QName("uri", "local"), Object.class, obj), (OutputStream)System.out);
    }
}

