/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.factories;

import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;

public class JBossSAMLBaseFactory {
    public static AttributeStatementType createAttributeStatement() {
        return new AttributeStatementType();
    }

    public static AttributeType createAttributeForRole(String roleName) {
        AttributeType att = new AttributeType("role");
        att.setFriendlyName("role");
        att.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_BASIC.get());
        att.addAttributeValue(roleName);
        return att;
    }

    public static AttributeStatementType createAttributeStatement(String attributeValue) {
        AttributeStatementType attribStatement = new AttributeStatementType();
        AttributeType att = new AttributeType(attributeValue);
        att.addAttributeValue(attributeValue);
        attribStatement.addAttribute(new AttributeStatementType.ASTChoiceType(att));
        return attribStatement;
    }

    public static SubjectConfirmationType createSubjectConfirmation(String method) {
        SubjectConfirmationType sct = new SubjectConfirmationType();
        sct.setMethod(method);
        return sct;
    }

    public static SubjectConfirmationDataType createSubjectConfirmationData(String inResponseTo, String destinationURI, XMLGregorianCalendar issueInstant) {
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo(inResponseTo);
        subjectConfirmationData.setRecipient(destinationURI);
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        return subjectConfirmationData;
    }

    public static String createUUID() {
        return UUID.randomUUID().toString();
    }

    public static NameIDType getIssuer(String issuerID) {
        NameIDType nid = new NameIDType();
        nid.setValue(issuerID);
        return nid;
    }
}

