/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.ChannelImpl;
import org.hornetq.core.protocol.core.impl.PacketDecoder;
import org.hornetq.core.protocol.core.impl.wireformat.DisconnectMessage;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.utils.SimpleIDGenerator;

public class RemotingConnectionImpl
implements CoreRemotingConnection {
    private static final boolean isTrace = HornetQClientLogger.LOGGER.isTraceEnabled();
    private final PacketDecoder packetDecoder;
    private final Connection transportConnection;
    private final Map<Long, Channel> channels = new ConcurrentHashMap<Long, Channel>();
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private final long blockingCallTimeout;
    private final long blockingCallFailoverTimeout;
    private final List<Interceptor> incomingInterceptors;
    private final List<Interceptor> outgoingInterceptors;
    private volatile boolean destroyed;
    private final boolean client;
    private int clientVersion;
    private volatile SimpleIDGenerator idGenerator;
    private boolean idGeneratorSynced;
    private final Object transferLock;
    private final Object failLock;
    private volatile boolean dataReceived;
    private final Executor executor;
    private volatile boolean executing;
    private final SimpleString nodeID;
    private final long creationTime;
    private String clientID;

    public RemotingConnectionImpl(PacketDecoder packetDecoder, Connection transportConnection, long blockingCallTimeout, long blockingCallFailoverTimeout, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors) {
        this(packetDecoder, transportConnection, blockingCallTimeout, blockingCallFailoverTimeout, incomingInterceptors, outgoingInterceptors, true, null, null);
    }

    RemotingConnectionImpl(PacketDecoder packetDecoder, Connection transportConnection, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors, Executor executor, SimpleString nodeID) {
        this(packetDecoder, transportConnection, -1L, -1L, incomingInterceptors, outgoingInterceptors, false, executor, nodeID);
    }

    private RemotingConnectionImpl(PacketDecoder packetDecoder, Connection transportConnection, long blockingCallTimeout, long blockingCallFailoverTimeout, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors, boolean client, Executor executor, SimpleString nodeID) {
        this.idGenerator = new SimpleIDGenerator(ChannelImpl.CHANNEL_ID.USER.id);
        this.idGeneratorSynced = false;
        this.transferLock = new Object();
        this.failLock = new Object();
        this.packetDecoder = packetDecoder;
        this.transportConnection = transportConnection;
        this.blockingCallTimeout = blockingCallTimeout;
        this.blockingCallFailoverTimeout = blockingCallFailoverTimeout;
        this.incomingInterceptors = incomingInterceptors;
        this.outgoingInterceptors = outgoingInterceptors;
        this.client = client;
        this.executor = executor;
        this.nodeID = nodeID;
        this.creationTime = System.currentTimeMillis();
    }

    public String toString() {
        return "RemotingConnectionImpl [clientID=" + this.clientID + ", nodeID=" + this.nodeID + ", transportConnection=" + this.transportConnection + "]";
    }

    @Override
    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    @Override
    public List<FailureListener> getFailureListeners() {
        return new ArrayList<FailureListener>(this.failureListeners);
    }

    @Override
    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    @Override
    public int getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void setClientVersion(int clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Override
    public Object getID() {
        return this.transportConnection.getID();
    }

    @Override
    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public synchronized Channel getChannel(long channelID, int confWindowSize) {
        Channel channel = this.channels.get(channelID);
        if (channel == null) {
            channel = new ChannelImpl(this, channelID, confWindowSize, this.outgoingInterceptors);
            this.channels.put(channelID, channel);
        }
        return channel;
    }

    @Override
    public synchronized boolean removeChannel(long channelID) {
        return this.channels.remove(channelID) != null;
    }

    @Override
    public synchronized void putChannel(long channelID, Channel channel) {
        this.channels.put(channelID, channel);
    }

    @Override
    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.failListenerCannotBeNull();
        }
        this.failureListeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.failListenerCannotBeNull();
        }
        return this.failureListeners.remove(listener);
    }

    @Override
    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.closeListenerCannotBeNull();
        }
        this.closeListeners.add(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.closeListenerCannotBeNull();
        }
        return this.closeListeners.remove(listener);
    }

    @Override
    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    @Override
    public List<FailureListener> removeFailureListeners() {
        ArrayList<FailureListener> ret = new ArrayList<FailureListener>(this.failureListeners);
        this.failureListeners.clear();
        return ret;
    }

    @Override
    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    @Override
    public HornetQBuffer createBuffer(int size) {
        return this.transportConnection.createBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(HornetQException me) {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        HornetQClientLogger.LOGGER.connectionFailureDetected(me.getMessage(), me.getType());
        this.callFailureListeners(me);
        this.callClosingListeners();
        this.internalClose();
        for (Channel channel : this.channels.values()) {
            channel.returnBlocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        this.internalClose();
        this.callClosingListeners();
    }

    @Override
    public void disconnect(boolean criticalError) {
        Channel channel0 = this.getChannel(0L, -1);
        HashSet<Channel> allChannels = new HashSet<Channel>(this.channels.values());
        if (!criticalError) {
            this.removeAllChannels();
        } else {
            this.channels.clear();
        }
        if (!criticalError) {
            for (Channel channel : allChannels) {
                channel.flushConfirmations();
            }
        }
        DisconnectMessage disconnect = new DisconnectMessage(this.nodeID);
        channel0.sendAndFlush(disconnect);
    }

    @Override
    public long generateChannelID() {
        return this.idGenerator.generateID();
    }

    @Override
    public synchronized void syncIDGeneratorSequence(long id) {
        if (!this.idGeneratorSynced) {
            this.idGenerator = new SimpleIDGenerator(id);
            this.idGeneratorSynced = true;
        }
    }

    @Override
    public long getIDGeneratorSequence() {
        return this.idGenerator.getCurrentID();
    }

    @Override
    public Object getTransferLock() {
        return this.transferLock;
    }

    @Override
    public boolean isClient() {
        return this.client;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public long getBlockingCallTimeout() {
        return this.blockingCallTimeout;
    }

    @Override
    public long getBlockingCallFailoverTimeout() {
        return this.blockingCallFailoverTimeout;
    }

    @Override
    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.transferLock;
        synchronized (object) {
            for (Channel channel : this.channels.values()) {
                channel.flushConfirmations();
            }
        }
    }

    @Override
    public HornetQPrincipal getDefaultHornetQPrincipal() {
        return this.transportConnection.getDefaultHornetQPrincipal();
    }

    @Override
    public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
        try {
            final Packet packet = this.packetDecoder.decode(buffer);
            if (isTrace) {
                HornetQClientLogger.LOGGER.trace("handling packet " + packet);
            }
            if (packet.isAsyncExec() && this.executor != null) {
                this.executing = true;
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RemotingConnectionImpl.this.doBufferReceived(packet);
                        }
                        catch (Throwable t) {
                            HornetQClientLogger.LOGGER.errorHandlingPacket(t, packet);
                        }
                        RemotingConnectionImpl.this.executing = false;
                    }
                });
            } else {
                while (this.executing) {
                    Thread.yield();
                }
                this.doBufferReceived(packet);
            }
            this.dataReceived = true;
        }
        catch (Exception e) {
            HornetQClientLogger.LOGGER.errorDecodingPacket(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBufferReceived(Packet packet) {
        if (ChannelImpl.invokeInterceptors(packet, this.incomingInterceptors, this) != null) {
            return;
        }
        Object object = this.transferLock;
        synchronized (object) {
            Channel channel = this.channels.get(packet.getChannelID());
            if (channel != null) {
                channel.handlePacket(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllChannels() {
        Object object = this.transferLock;
        synchronized (object) {
            this.channels.clear();
        }
    }

    private void callFailureListeners(HornetQException me) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (HornetQInterruptedException interrupted) {
                HornetQClientLogger.LOGGER.debug("thread interrupted", interrupted);
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    private void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    private void internalClose() {
        this.transportConnection.close();
        for (Channel channel : this.channels.values()) {
            channel.close();
        }
    }

    public void setClientID(String cID) {
        this.clientID = cID;
    }

    public String getClientID() {
        return this.clientID;
    }
}

