/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.WriterException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

@Provider
@Consumes(value={"text/yaml", "text/x-yaml", "application/x-yaml"})
@Produces(value={"text/yaml", "text/x-yaml", "application/x-yaml"})
public class YamlProvider
extends AbstractEntityProvider<Object> {
    static final Logger logger = Logger.getLogger(YamlProvider.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return new Yaml().load(entityStream);
        }
        catch (YAMLException ye) {
            logger.debug("Failed to decode Yaml: {0}", new Object[]{ye.getMessage()});
            throw new ReaderException("Failed to decode Yaml", (Throwable)ye);
        }
        catch (Exception e) {
            logger.debug("Failed to decode Yaml: {0}", new Object[]{e.getMessage()});
            throw new ReaderException("Failed to decode Yaml", (Throwable)e);
        }
    }

    protected boolean isValidType(Class type) {
        if (List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || type.isArray()) {
            return true;
        }
        if (StreamingOutput.class.isAssignableFrom(type)) {
            return false;
        }
        String className = type.getName();
        if (className.startsWith("java.")) {
            return false;
        }
        if (className.startsWith("javax.")) {
            return false;
        }
        return !type.isPrimitive();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isValidType(type);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            entityStream.write(new Yaml().dump(t).getBytes());
        }
        catch (Exception e) {
            logger.debug("Failed to encode yaml for object: {0}", new Object[]{t.toString()});
            throw new WriterException((Throwable)e);
        }
    }
}

