/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.util.LoggerUtil;
import org.jboss.aesh.util.Parser;

public class FileUtils {
    private static final Pattern startsWithParent = Pattern.compile("^\\.\\..*");
    private static final Pattern containParent = Config.isOSPOSIXCompatible() ? Pattern.compile("[\\.\\.[" + Config.getPathSeparator() + "]?]+") : Pattern.compile("[\\.\\.[\\\\]?]+");
    private static final Pattern space = Pattern.compile(".+\\s+.+");
    private static final Pattern startsWithSlash = Config.isOSPOSIXCompatible() ? Pattern.compile("^\\" + Config.getPathSeparator() + ".*") : Pattern.compile("^\\\\.*");
    private static final Pattern endsWithSlash = Config.isOSPOSIXCompatible() ? Pattern.compile(".*\\" + Config.getPathSeparator() + "$") : Pattern.compile(".*\\\\$");
    private static Logger logger = LoggerUtil.getLogger(FileUtils.class.getName());

    public static void listMatchingDirectories(CompleteOperation completion, String possibleDir, File cwd) {
        completion.doAppendSeparator(false);
        ArrayList<String> returnFiles = new ArrayList<String>();
        if (possibleDir.trim().isEmpty()) {
            List<String> allFiles = FileUtils.listDirectory(cwd);
            for (String file : allFiles) {
                if (!file.startsWith(possibleDir)) continue;
                returnFiles.add(Parser.switchSpacesToEscapedSpacesInWord(file.substring(possibleDir.length())));
            }
            completion.addCompletionCandidates(returnFiles);
        } else if (!startsWithSlash.matcher(possibleDir).matches() && new File(cwd.getAbsolutePath() + Config.getPathSeparator() + possibleDir).isDirectory()) {
            if (!endsWithSlash.matcher(possibleDir).matches()) {
                returnFiles.add(Config.getPathSeparator());
                completion.addCompletionCandidates(returnFiles);
            } else {
                completion.addCompletionCandidates(FileUtils.listDirectory(new File(cwd.getAbsolutePath() + Config.getPathSeparator() + possibleDir)));
            }
        } else if (new File(cwd.getAbsolutePath() + Config.getPathSeparator() + possibleDir).isFile()) {
            returnFiles.add("");
            completion.addCompletionCandidates(returnFiles);
            completion.doAppendSeparator(true);
        } else if (startsWithSlash.matcher(possibleDir).matches() && new File(possibleDir).isFile()) {
            returnFiles.add("");
            completion.addCompletionCandidates(returnFiles);
            completion.doAppendSeparator(true);
        } else {
            returnFiles = new ArrayList();
            if (new File(possibleDir).isDirectory() && !endsWithSlash.matcher(possibleDir).matches()) {
                returnFiles.add(Config.getPathSeparator());
                completion.addCompletionCandidates(returnFiles);
                return;
            }
            if (new File(possibleDir).isDirectory() && !endsWithSlash.matcher(possibleDir).matches()) {
                completion.addCompletionCandidates(FileUtils.listDirectory(new File(possibleDir)));
                return;
            }
            String lastDir = null;
            String rest = null;
            if (possibleDir.contains(Config.getPathSeparator())) {
                lastDir = possibleDir.substring(0, possibleDir.lastIndexOf(Config.getPathSeparator()));
                rest = possibleDir.substring(possibleDir.lastIndexOf(Config.getPathSeparator()) + 1);
            } else if (new File(cwd + Config.getPathSeparator() + possibleDir).exists()) {
                lastDir = possibleDir;
            } else {
                rest = possibleDir;
            }
            List<String> allFiles = startsWithSlash.matcher(possibleDir).matches() ? (lastDir != null && lastDir.startsWith(Config.getPathSeparator()) ? FileUtils.listDirectory(new File(lastDir)) : FileUtils.listDirectory(new File(Config.getPathSeparator() + lastDir))) : (lastDir != null ? FileUtils.listDirectory(new File(cwd + Config.getPathSeparator() + lastDir)) : FileUtils.listDirectory(cwd));
            if (rest != null && !rest.isEmpty()) {
                for (String file : allFiles) {
                    if (!file.startsWith(rest)) continue;
                    returnFiles.add(Parser.switchSpacesToEscapedSpacesInWord(file.substring(rest.length())));
                }
            } else {
                for (String file : allFiles) {
                    returnFiles.add(Parser.switchSpacesToEscapedSpacesInWord(file));
                }
            }
            if (returnFiles.size() > 1) {
                String startsWith = Parser.findStartsWith(returnFiles);
                if (startsWith != null && startsWith.length() > 0) {
                    returnFiles.clear();
                    returnFiles.add(Parser.switchSpacesToEscapedSpacesInWord(startsWith));
                } else {
                    returnFiles.clear();
                    for (String file : allFiles) {
                        if (!file.startsWith(rest)) continue;
                        returnFiles.add(Parser.switchSpacesToEscapedSpacesInWord(file));
                    }
                }
            }
            completion.addCompletionCandidates(returnFiles);
            if (returnFiles.size() > 1 && rest != null && rest.length() > 0) {
                completion.setOffset(completion.getCursor() - rest.length());
            }
        }
    }

    private static List<String> listDirectory(File path) {
        ArrayList<String> fileNames = new ArrayList<String>();
        if (path != null && path.isDirectory()) {
            for (File file : path.listFiles()) {
                fileNames.add(file.getName());
            }
        }
        return fileNames;
    }

    public static String getDirectoryName(File path, File home) {
        if (path.getAbsolutePath().startsWith(home.getAbsolutePath())) {
            return "~" + path.getAbsolutePath().substring(home.getAbsolutePath().length());
        }
        return path.getAbsolutePath();
    }

    public static File getFile(String name, String cwd) {
        if (containParent.matcher(name).matches()) {
            if (startsWithParent.matcher(name).matches()) {
                // empty if block
            }
        } else if (!name.startsWith("~")) {
            return new File(name);
        }
        return null;
    }

    public static void saveFile(File file, String text, boolean append) throws IOException {
        if (file.isDirectory()) {
            if (Settings.getInstance().isLogging()) {
                logger.info("Cannot save file " + file + ", it is a directory");
            }
            throw new IOException(file + ": Is a directory");
        }
        if (file.isFile()) {
            FileWriter fileWriter = append ? new FileWriter(file, true) : new FileWriter(file, false);
            fileWriter.write(text);
            fileWriter.flush();
            fileWriter.close();
        } else {
            FileWriter fileWriter = new FileWriter(file, false);
            fileWriter.write(text);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        if (file.isDirectory()) {
            if (Settings.getInstance().isLogging()) {
                logger.info("Cannot save file " + file + ", it is a directory");
            }
            throw new IOException(file + ": Is a directory");
        }
        if (file.isFile()) {
            BufferedReader br = new BufferedReader(new FileReader(file));
            try {
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line).append(Config.getLineSeparator());
                    line = br.readLine();
                }
                String string = sb.toString();
                return string;
            }
            finally {
                br.close();
            }
        }
        if (Settings.getInstance().isLogging()) {
            logger.info("Cannot read file " + file + ", file unknown");
        }
        throw new IOException(file + ": File unknown");
    }
}

