/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.JBossPortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.util.StAXUtils;

public class JBossWebservicesFactory {
    private URL descriptorURL;

    public JBossWebservicesFactory(URL descriptorURL) {
        this.descriptorURL = descriptorURL;
    }

    public URL getDescriptorURL() {
        return this.descriptorURL;
    }

    public static JBossWebservicesMetaData loadFromVFSRoot(UnifiedVirtualFile root) {
        JBossWebservicesMetaData webservices = null;
        UnifiedVirtualFile wsdd = root.findChildFailSafe("META-INF/jboss-webservices.xml");
        if (null == wsdd) {
            wsdd = root.findChildFailSafe("WEB-INF/jboss-webservices.xml");
        }
        if (wsdd != null) {
            return JBossWebservicesFactory.load(wsdd.toURL());
        }
        return webservices;
    }

    public static JBossWebservicesMetaData load(URL wsddUrl) {
        InputStream is = null;
        try {
            is = wsddUrl.openStream();
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            JBossWebservicesMetaData jBossWebservicesMetaData = JBossWebservicesFactory.parse(xmlr, wsddUrl);
            return jBossWebservicesMetaData;
        }
        catch (Exception e) {
            throw Messages.MESSAGES.failedToUnmarshall(e, wsddUrl);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static JBossWebservicesMetaData parse(InputStream is) {
        return JBossWebservicesFactory.parse(is, null);
    }

    public static JBossWebservicesMetaData parse(InputStream is, URL descriptorURL) {
        try {
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            return JBossWebservicesFactory.parse(xmlr, descriptorURL);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static JBossWebservicesMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return JBossWebservicesFactory.parse(reader, null);
    }

    private static JBossWebservicesMetaData parse(XMLStreamReader reader, URL descriptorURL) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        JBossWebservicesMetaData metadata = null;
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match(reader, "http://www.jboss.com/xml/ns/javaee", "webservices")) {
                    String nsUri = reader.getNamespaceURI();
                    JBossWebservicesFactory factory = new JBossWebservicesFactory(descriptorURL);
                    metadata = factory.parseWebservices(reader, nsUri, descriptorURL);
                    break;
                }
                throw Messages.MESSAGES.unexpectedElement(descriptorURL != null ? descriptorURL.toString() : "jboss-webservices.xml", reader.getLocalName());
            }
        }
        return metadata;
    }

    private JBossWebservicesMetaData parseWebservices(XMLStreamReader reader, String nsUri, URL descriptorURL) throws XMLStreamException {
        JBossWebservicesMetaData metadata = new JBossWebservicesMetaData(descriptorURL);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "webservices")) {
                        return metadata;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "context-root")) {
                        metadata.setContextRoot(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "config-name")) {
                        metadata.setConfigName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "config-file")) {
                        metadata.setConfigFile(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "property")) {
                        this.parseProperty(reader, nsUri, metadata);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "port-component")) {
                        metadata.addPortComponent(this.parsePortComponent(reader, nsUri));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "webservice-description")) {
                        metadata.addWebserviceDescription(this.parseWebserviceDescription(reader, nsUri));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private JBossPortComponentMetaData parsePortComponent(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        JBossPortComponentMetaData pc = new JBossPortComponentMetaData();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "port-component")) {
                        return pc;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "ejb-name")) {
                        pc.setEjbName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "port-component-name")) {
                        pc.setPortComponentName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "port-component-uri")) {
                        pc.setPortComponentURI(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "auth-method")) {
                        pc.setAuthMethod(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "transport-guarantee")) {
                        pc.setTransportGuarantee(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "secure-wsdl-access")) {
                        pc.setSecureWSDLAccess(StAXUtils.elementAsBoolean(reader));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private JBossWebserviceDescriptionMetaData parseWebserviceDescription(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        JBossWebserviceDescriptionMetaData description = new JBossWebserviceDescriptionMetaData();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description")) {
                        return description;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description-name")) {
                        description.setWebserviceDescriptionName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "wsdl-publish-location")) {
                        description.setWsdlPublishLocation(StAXUtils.elementAsString(reader));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private void parseProperty(XMLStreamReader reader, String nsUri, JBossWebservicesMetaData metadata) throws XMLStreamException {
        String name = null;
        String value = null;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "property")) {
                        if (name == null) {
                            throw Messages.MESSAGES.couldNotGetPropertyName(this.getDescriptorForLogs());
                        }
                        metadata.setProperty(name, value);
                        return;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "name")) {
                        name = StAXUtils.elementAsString(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "value")) {
                        value = StAXUtils.elementAsString(reader);
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private String getDescriptorForLogs() {
        return this.descriptorURL != null ? this.descriptorURL.toString() : "jboss-webservices.xml";
    }
}

