/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.lookup;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.infinispan.config.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JBossStandaloneJTAManagerLookup
implements TransactionManagerLookup {
    private Method manager;
    private Method user;
    private static final Log log = LogFactory.getLog(JBossStandaloneJTAManagerLookup.class);

    @Deprecated
    public void init(Configuration configuration) {
        this.init(configuration.getClassLoader());
    }

    @Inject
    public void init(org.infinispan.configuration.cache.Configuration configuration) {
        this.init(configuration.classLoader());
    }

    private void init(ClassLoader classLoader) {
        try {
            this.manager = Util.loadClass("com.arjuna.ats.jta.TransactionManager", classLoader).getMethod("transactionManager", new Class[0]);
            this.user = Util.loadClass("com.arjuna.ats.jta.UserTransaction", classLoader).getMethod("userTransaction", new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized TransactionManager getTransactionManager() throws Exception {
        TransactionManager tm = (TransactionManager)this.manager.invoke(null, new Object[0]);
        if (log.isInfoEnabled()) {
            log.retrievingTm(tm);
        }
        return tm;
    }

    public UserTransaction getUserTransaction() throws Exception {
        return (UserTransaction)this.user.invoke(null, new Object[0]);
    }
}

