/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AbstractTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectDefinition;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class RejectTransformationDescriptionBuilder
extends AbstractTransformationDescriptionBuilder
implements TransformationDescriptionBuilder {
    private static OperationTransformer REJECT_OPERATION = new OperationTransformer(){

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
            return new OperationTransformer.TransformedOperation(null, new OperationRejectionPolicy(){

                @Override
                public boolean rejectOperation(ModelNode preparedResult) {
                    return true;
                }

                @Override
                public String getFailureDescription() {
                    return ControllerMessages.MESSAGES.rejectResourceOperationTransformation(address, operation);
                }
            }, OperationResultTransformer.ORIGINAL_RESULT);
        }
    };
    private static ResourceTransformer REJECT_RESOURCE = new ResourceTransformer(){

        @Override
        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) {
            context.getLogger().logRejectedResourceWarning(address, null);
        }
    };

    protected RejectTransformationDescriptionBuilder(PathElement pathElement) {
        super(pathElement, PathAddressTransformer.DEFAULT, REJECT_RESOURCE, REJECT_OPERATION);
    }

    @Override
    public TransformationDescription build() {
        return new RejectDefinition(this.pathElement, REJECT_RESOURCE, REJECT_OPERATION);
    }
}

