/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AbstractDescription;
import org.jboss.as.controller.transform.description.AttributeTransformationDescription;
import org.jboss.as.controller.transform.description.AttributeTransformationRule;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.OperationTransformationRules;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationRule;
import org.jboss.dmr.ModelNode;

class TransformingDescription
extends AbstractDescription
implements TransformationDescription,
ResourceTransformer,
OperationTransformer {
    private final DiscardPolicy discardPolicy;
    private final List<TransformationDescription> children;
    private final Map<String, AttributeTransformationDescription> attributeTransformations;
    private final List<TransformationRule> rules = Collections.emptyList();
    private final Map<String, OperationTransformer> operationTransformers;
    private final ResourceTransformer resourceTransformer;

    public TransformingDescription(PathElement pathElement, PathAddressTransformer pathAddressTransformer, DiscardPolicy discardPolicy, ResourceTransformer resourceTransformer, Map<String, AttributeTransformationDescription> attributeTransformations, Map<String, OperationTransformer> operations, List<TransformationDescription> children) {
        super(pathElement, pathAddressTransformer);
        this.children = children;
        this.discardPolicy = discardPolicy;
        this.resourceTransformer = resourceTransformer;
        this.attributeTransformations = attributeTransformations;
        this.operationTransformers = operations;
        if (!this.operationTransformers.containsKey("write-attribute")) {
            this.operationTransformers.put("write-attribute", OperationTransformationRules.createWriteOperation(attributeTransformations));
        }
        if (!this.operationTransformers.containsKey("undefine-attribute")) {
            this.operationTransformers.put("undefine-attribute", OperationTransformationRules.createUndefinedOperation(attributeTransformations));
        }
    }

    @Override
    public OperationTransformer getOperationTransformer() {
        return this;
    }

    @Override
    public ResourceTransformer getResourceTransformer() {
        return this;
    }

    @Override
    public Map<String, OperationTransformer> getOperationTransformers() {
        return Collections.unmodifiableMap(this.operationTransformers);
    }

    @Override
    public List<TransformationDescription> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext ctx, final PathAddress address, ModelNode operation) throws OperationFailedException {
        if (this.discardPolicy.discard(operation, address, ctx) == DiscardPolicy.DiscardType.SILENT) {
            return OperationTransformer.DISCARD.transformOperation(ctx, address, operation);
        }
        final Iterator<TransformationRule> iterator = this.rules.iterator();
        TransformationRule.ChainedOperationContext context = new TransformationRule.ChainedOperationContext(ctx){

            @Override
            void invokeNext(OperationTransformer.TransformedOperation transformedOperation) throws OperationFailedException {
                this.recordTransformedOperation(transformedOperation);
                if (iterator.hasNext()) {
                    TransformationRule next = (TransformationRule)iterator.next();
                    next.transformOperation(transformedOperation.getTransformedOperation(), address, this);
                }
            }
        };
        AttributeTransformationRule first = new AttributeTransformationRule(this.attributeTransformations);
        ((TransformationRule)first).transformOperation(operation, address, context);
        return context.createOp();
    }

    @Override
    public void transformResource(final ResourceTransformationContext ctx, final PathAddress address, Resource original) throws OperationFailedException {
        ModelNode originalModel = TransformationRule.cloneAndProtect(original.getModel());
        if (this.discardPolicy.discard(originalModel, address, ctx) == DiscardPolicy.DiscardType.SILENT) {
            return;
        }
        final Iterator<TransformationRule> iterator = this.rules.iterator();
        TransformationRule.ChainedResourceContext context = new TransformationRule.ChainedResourceContext(ctx){

            @Override
            void invokeNext(Resource resource) throws OperationFailedException {
                if (iterator.hasNext()) {
                    TransformationRule next = (TransformationRule)iterator.next();
                    next.transformResource(resource, address, this);
                } else {
                    TransformingDescription.this.resourceTransformer.transformResource(ctx, address, resource);
                }
            }
        };
        AttributeTransformationRule rule = new AttributeTransformationRule(this.attributeTransformations);
        ((TransformationRule)rule).transformResource(original, address, context);
    }

    @Override
    public boolean isInherited() {
        return false;
    }
}

