/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.jacorb.JacORBLogger;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.ORBInitializer;
import org.jboss.as.jacorb.PropertiesMap;
import org.jboss.as.jacorb.SSLConfigValue;
import org.jboss.as.jacorb.SecurityActions;
import org.jboss.as.jacorb.deployment.JacORBDependencyProcessor;
import org.jboss.as.jacorb.deployment.JacORBMarkerProcessor;
import org.jboss.as.jacorb.naming.jndi.JBossCNCtxFactory;
import org.jboss.as.jacorb.rmi.DelegatingStubFactoryFactory;
import org.jboss.as.jacorb.security.DomainServerSocketFactory;
import org.jboss.as.jacorb.security.DomainSocketFactory;
import org.jboss.as.jacorb.service.CorbaNamingService;
import org.jboss.as.jacorb.service.CorbaORBService;
import org.jboss.as.jacorb.service.CorbaPOAService;
import org.jboss.as.naming.InitialContext;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.com.sun.corba.se.spi.orb.ORB;
import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;

public class JacORBSubsystemAdd
extends AbstractAddStepHandler {
    static final JacORBSubsystemAdd INSTANCE = new JacORBSubsystemAdd();
    private static final ServiceName SECURITY_DOMAIN_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"security"}).append(new String[]{"security-domain"});

    private JacORBSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attrDefinition : JacORBSubsystemDefinitions.SUBSYSTEM_ATTRIBUTES) {
            attrDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        JacORBLogger.ROOT_LOGGER.activatingSubsystem();
        SecurityActions.setSystemProperty("org.jboss.com.sun.CORBA.ORBUseDynamicStub", "true");
        ORB.getPresentationManager().setStubFactoryFactory(true, (PresentationManager.StubFactoryFactory)new DelegatingStubFactoryFactory());
        ORB.getPresentationManager().setStubFactoryFactory(false, (PresentationManager.StubFactoryFactory)new DelegatingStubFactoryFactory());
        InitialContext.addUrlContextFactory((String)"corbaloc", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"corbaname", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"IOR", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"iiopname", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"iiop", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("jacorb", Phase.DEPENDENCIES, 4864, (DeploymentUnitProcessor)new JacORBDependencyProcessor());
                processorTarget.addDeploymentProcessor("jacorb", Phase.PARSE, 16640, (DeploymentUnitProcessor)new JacORBMarkerProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        Properties props = this.getConfigurationProperties(context, model);
        this.setupInitializers(props);
        this.setupSSLFactories(props);
        CorbaORBService orbService = new CorbaORBService(props);
        ServiceBuilder builder = context.getServiceTarget().addService(CorbaORBService.SERVICE_NAME, (Service)orbService);
        Services.addServerExecutorDependency((ServiceBuilder)builder, orbService.getExecutorInjector(), (boolean)false);
        String securityDomain = props.getProperty("security-domain");
        if (securityDomain != null && !securityDomain.isEmpty()) {
            builder.addDependency(SECURITY_DOMAIN_SERVICE_NAME.append(new String[]{securityDomain}));
        }
        String socketBinding = props.getProperty("socket-binding");
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBinding}), SocketBinding.class, orbService.getJacORBSocketBindingInjector());
        String sslSocketBinding = props.getProperty("ssl-socket-binding");
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{sslSocketBinding}), SocketBinding.class, orbService.getJacORBSSLSocketBindingInjector());
        builder.addListener((ServiceListener)verificationHandler);
        newControllers.add(builder.setInitialMode(ServiceController.Mode.ACTIVE).install());
        CorbaPOAService rootPOAService = new CorbaPOAService("RootPOA", "poa");
        newControllers.add(context.getServiceTarget().addService(CorbaPOAService.ROOT_SERVICE_NAME, (Service)rootPOAService).addDependency(CorbaORBService.SERVICE_NAME, org.omg.CORBA.ORB.class, rootPOAService.getORBInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        CorbaPOAService irPOAService = new CorbaPOAService("IRPOA", "irpoa", IdAssignmentPolicyValue.USER_ID, null, null, LifespanPolicyValue.PERSISTENT, null, null, null);
        newControllers.add(context.getServiceTarget().addService(CorbaPOAService.INTERFACE_REPOSITORY_SERVICE_NAME, (Service)irPOAService).addDependency(CorbaPOAService.ROOT_SERVICE_NAME, POA.class, irPOAService.getParentPOAInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        CorbaPOAService namingPOAService = new CorbaPOAService("Naming", null, IdAssignmentPolicyValue.USER_ID, null, null, LifespanPolicyValue.PERSISTENT, null, null, null);
        newControllers.add(context.getServiceTarget().addService(CorbaPOAService.SERVICE_NAME.append(new String[]{"namingpoa"}), (Service)namingPOAService).addDependency(CorbaPOAService.ROOT_SERVICE_NAME, POA.class, namingPOAService.getParentPOAInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        CorbaNamingService namingService = new CorbaNamingService();
        newControllers.add(context.getServiceTarget().addService(CorbaNamingService.SERVICE_NAME, (Service)namingService).addDependency(CorbaORBService.SERVICE_NAME, org.omg.CORBA.ORB.class, namingService.getORBInjector()).addDependency(CorbaPOAService.ROOT_SERVICE_NAME, POA.class, namingService.getRootPOAInjector()).addDependency(CorbaPOAService.SERVICE_NAME.append(new String[]{"namingpoa"}), POA.class, namingService.getNamingPOAInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    private Properties getConfigurationProperties(OperationContext context, ModelNode model) throws OperationFailedException {
        String value;
        String name;
        Properties props = new Properties();
        for (AttributeDefinition attrDefinition : JacORBSubsystemDefinitions.SUBSYSTEM_ATTRIBUTES) {
            SSLConfigValue sslConfigValue;
            ModelNode resolvedModelAttribute = attrDefinition.resolveModelAttribute(context, model);
            if (!resolvedModelAttribute.isDefined()) continue;
            name = attrDefinition.getName();
            value = resolvedModelAttribute.asString();
            String jacorbProperty = PropertiesMap.JACORB_PROPS_MAP.get(name);
            if (jacorbProperty != null) {
                name = jacorbProperty;
            }
            if (JacORBSubsystemDefinitions.SSL_CONFIG_ATTRIBUTES.contains(attrDefinition) && (sslConfigValue = SSLConfigValue.valueOf(value.toUpperCase(Locale.ENGLISH))) != null) {
                value = sslConfigValue.getJacorbValue();
            }
            props.setProperty(name, value);
        }
        if (model.hasDefined("properties")) {
            ModelNode propertiesNode = model.get("properties");
            for (Property property : propertiesNode.asPropertyList()) {
                name = property.getName();
                value = property.getValue();
                props.setProperty(name, value.asString());
            }
        }
        return props;
    }

    private void setupInitializers(Properties props) {
        ArrayList<String> orbInitializers = new ArrayList<String>();
        String installSecurity = (String)props.remove("security");
        if (installSecurity.equalsIgnoreCase("client")) {
            orbInitializers.addAll(Arrays.asList(ORBInitializer.SECURITY_CLIENT.getInitializerClasses()));
        } else if (installSecurity.equalsIgnoreCase("identity")) {
            orbInitializers.addAll(Arrays.asList(ORBInitializer.SECURITY_IDENTITY.getInitializerClasses()));
        }
        String installTransaction = (String)props.remove("transactions");
        if (installTransaction.equalsIgnoreCase("on")) {
            orbInitializers.addAll(Arrays.asList(ORBInitializer.TRANSACTIONS.getInitializerClasses()));
        } else if (installTransaction.equalsIgnoreCase("spec")) {
            orbInitializers.addAll(Arrays.asList(ORBInitializer.SPEC_TRANSACTIONS.getInitializerClasses()));
        }
        props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        for (String initializerClass : orbInitializers) {
            props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass." + initializerClass, "");
        }
    }

    private void setupSSLFactories(Properties props) throws OperationFailedException {
        String supportSSLKey = PropertiesMap.JACORB_PROPS_MAP.get("support-ssl");
        boolean supportSSL = "on".equalsIgnoreCase(props.getProperty(supportSSLKey));
        if (supportSSL) {
            String securityDomain = props.getProperty("security-domain");
            if (securityDomain == null || securityDomain.isEmpty()) {
                throw JacORBMessages.MESSAGES.noSecurityDomainSpecified();
            }
            props.setProperty("jacorb.ssl.socket_factory", DomainSocketFactory.class.getName());
            props.setProperty("jacorb.ssl.server_socket_factory", DomainServerSocketFactory.class.getName());
        }
    }
}

