/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.CliShutdownHook;
import org.jboss.as.cli.impl.ModelControllerClientFactory;
import org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.threads.JBossThreadFactory;
import org.xnio.OptionMap;

public class CLIModelControllerClient
extends AbstractModelControllerClient {
    private static final OptionMap DEFAULT_OPTIONS = OptionMap.create(RemotingOptions.TRANSMIT_WINDOW_SIZE, 32768, RemotingOptions.RECEIVE_WINDOW_SIZE, 32768);
    private static final ThreadPoolExecutor executorService;
    private static final Endpoint endpoint;
    private final CallbackHandler handler;
    private final SSLContext sslContext;
    private final ModelControllerClientFactory.ConnectionCloseHandler closeHandler;
    private final ManagementChannelHandler channelAssociation;
    private ManagementClientChannelStrategy strategy;
    private final ProtocolChannelClient.Configuration channelConfig;
    private boolean closed;

    CLIModelControllerClient(CallbackHandler handler, String hostName, int connectionTimeout, ModelControllerClientFactory.ConnectionCloseHandler closeHandler, int port, SSLContext sslContext) throws IOException {
        this.handler = handler;
        this.sslContext = sslContext;
        this.closeHandler = closeHandler;
        this.channelAssociation = new ManagementChannelHandler(new ManagementClientChannelStrategy(){

            @Override
            public Channel getChannel() throws IOException {
                return CLIModelControllerClient.this.getOrCreateChannel();
            }

            @Override
            public synchronized void close() throws IOException {
            }
        }, (ExecutorService)executorService, this);
        this.channelConfig = new ProtocolChannelClient.Configuration();
        try {
            this.channelConfig.setUri(new URI("remote://" + CLIModelControllerClient.formatPossibleIpv6Address(hostName) + ":" + port));
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to create URI", e);
        }
        this.channelConfig.setOptionMap(DEFAULT_OPTIONS);
        if (connectionTimeout > 0) {
            this.channelConfig.setConnectionTimeout(connectionTimeout);
        }
        this.channelConfig.setEndpoint(endpoint);
    }

    @Override
    protected ManagementChannelAssociation getChannelAssociation() throws IOException {
        return this.channelAssociation;
    }

    protected synchronized Channel getOrCreateChannel() throws IOException {
        if (this.strategy == null) {
            ProtocolChannelClient setup = ProtocolChannelClient.create(this.channelConfig);
            this.strategy = ManagementClientChannelStrategy.create(setup, this.channelAssociation, this.handler, null, this.sslContext, new CloseHandler<Channel>(){

                @Override
                public void handleClose(Channel closed, IOException exception) {
                    CLIModelControllerClient.this.channelAssociation.handleChannelClosed(closed, exception);
                }
            });
            this.strategy.getChannel().getConnection().addCloseHandler(new CloseHandler<Connection>(){

                @Override
                public void handleClose(Connection closed, IOException exception) {
                    CLIModelControllerClient.this.closeHandler.handleClose();
                    StreamUtils.safeClose(CLIModelControllerClient.this.strategy);
                    CLIModelControllerClient.this.strategy = null;
                }
            });
        }
        return this.strategy.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CLIModelControllerClient cLIModelControllerClient = this;
        synchronized (cLIModelControllerClient) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.channelAssociation.shutdown();
            if (this.strategy != null) {
                StreamUtils.safeClose(this.strategy);
                this.strategy = null;
            }
            this.channelAssociation.shutdownNow();
            try {
                this.channelAssociation.awaitCompletion(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelNode execute(ModelNode operation, boolean awaitClose) throws IOException {
        ModelNode response = super.execute(operation);
        if (!Util.isSuccess(response)) {
            return response;
        }
        if (awaitClose) {
            CLIModelControllerClient cLIModelControllerClient = this;
            synchronized (cLIModelControllerClient) {
                try {
                    if (this.strategy == null) {
                        throw new IOException("Connection has been closed.");
                    }
                    this.strategy.getChannel().getConnection().awaitClosed();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return response;
    }

    private static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }

    static {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("cli-remoting"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
        executorService = new ThreadPoolExecutor(2, 4, 60L, TimeUnit.SECONDS, workQueue, threadFactory);
        executorService.allowCoreThreadTimeOut(true);
        try {
            endpoint = Remoting.createEndpoint("cli-client", OptionMap.EMPTY);
            endpoint.addConnectionProvider("remote", new RemoteConnectionProviderFactory(), OptionMap.EMPTY);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create remoting endpoint", e);
        }
        CliShutdownHook.add(new CliShutdownHook.Handler(){

            @Override
            public void shutdown() {
                executorService.shutdown();
                try {
                    executorService.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    endpoint.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }
}

