/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.web.WebMessages;
import org.jboss.dmr.ModelNode;

public class WriteDefaultWebModule
implements OperationStepHandler {
    static final WriteDefaultWebModule INSTANCE = new WriteDefaultWebModule();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode virtualHost = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        String war = operation.get("value").asString();
        if (virtualHost.hasDefined("enable-welcome-root") && virtualHost.get("enable-welcome-root").asBoolean()) {
            throw new OperationFailedException(WebMessages.MESSAGES.noWelcomeWebappWithDefaultWebModule());
        }
        virtualHost.get("default-web-module").set(war);
        if (context.isNormalServer()) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (context.isNormalServer()) {
                    context.revertReloadRequired();
                }
            }
        });
    }
}

