/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.utils.jcip.Immutable;
import io.fabric8.utils.jcip.ThreadSafe;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Immutable
@ThreadSafe
public class CreateEnsembleOptions {
    public static final String AGENT_AUTOSTART = "agent.auto.start";
    public static final String ENSEMBLE_AUTOSTART = "ensemble.auto.start";
    public static final String PROFILES_AUTOIMPORT = "profiles.auto.import";
    public static final String PROFILES_AUTOIMPORT_PATH = "profiles.auto.import.path";
    public static final String DEFAULT_IMPORT_PATH = "fabric" + File.separatorChar + "import";
    public static final String ZOOKEEPER_PASSWORD = "zookeeper.password";
    public static String ZOOKEEPER_SERVER_PORT = "zookeeper.server.port";
    public static String ZOOKEEPER_SERVER_CONNECTION_PORT = "zookeeper.server.connection.port";
    public static final String ROLE_DELIMITER = ",";
    public static final long DEFAULT_MIGRATION_TIMEOUT = 120000L;
    public static final int DEFAULT_TICKTIME = 2000;
    public static final int DEFAULT_INIT_LIMIT = 10;
    public static final int DEFAULT_SYNC_LIMIT = 5;
    public static final String DEFAULT_DATA_DIR = "zookeeper";
    @JsonProperty
    final int zooKeeperServerPort;
    @JsonProperty
    final int zooKeeperServerConnectionPort;
    @JsonProperty
    final int zooKeeperServerTickTime;
    @JsonProperty
    final int zooKeeperServerInitLimit;
    @JsonProperty
    final int zooKeeperServerSyncLimit;
    @JsonProperty
    final String zooKeeperServerDataDir;
    @JsonProperty
    final String zookeeperPassword;
    @JsonProperty
    final boolean ensembleStart;
    @JsonProperty
    final boolean agentEnabled;
    @JsonProperty
    final boolean waitForProvision;
    @JsonProperty
    final long bootstrapTimeout;
    @JsonProperty
    final long migrationTimeout;
    @JsonProperty
    final boolean autoImportEnabled;
    @JsonProperty
    final String importPath;
    @JsonProperty
    final boolean clean;
    @JsonProperty
    final Map<String, String> users;

    CreateEnsembleOptions(String bindAddress, String resolver, String globalResolver, String manualIp, int minimumPort, int maximumPort, Set<String> profiles, String version, Map<String, String> dataStoreProperties, int zooKeeperServerPort, int zooKeeperServerConnectionPort, int zooKeeperServerTickTime, int zooKeeperServerInitLimit, int zooKeeperServerSyncLimit, String zooKeeperServerDataDir, String zookeeperPassword, boolean ensembleStart, boolean agentEnabled, boolean waitForProvision, long bootstrapTimeout, long migrationTimeout, boolean autoImportEnabled, String importPath, Map<String, String> users, boolean clean) {
        this.zooKeeperServerPort = zooKeeperServerPort;
        this.zooKeeperServerConnectionPort = zooKeeperServerConnectionPort;
        this.zookeeperPassword = zookeeperPassword;
        this.ensembleStart = ensembleStart;
        this.agentEnabled = agentEnabled;
        this.waitForProvision = waitForProvision;
        this.bootstrapTimeout = bootstrapTimeout;
        this.migrationTimeout = migrationTimeout;
        this.autoImportEnabled = autoImportEnabled;
        this.importPath = importPath;
        this.zooKeeperServerTickTime = zooKeeperServerTickTime;
        this.zooKeeperServerInitLimit = zooKeeperServerInitLimit;
        this.zooKeeperServerSyncLimit = zooKeeperServerSyncLimit;
        this.zooKeeperServerDataDir = zooKeeperServerDataDir;
        this.users = Collections.unmodifiableMap(new HashMap<String, String>(users));
        this.clean = clean;
    }

    public int getZooKeeperServerPort() {
        return this.zooKeeperServerPort;
    }

    public int getZooKeeperServerConnectionPort() {
        return this.zooKeeperServerConnectionPort;
    }

    public int getZooKeeperServerTickTime() {
        return this.zooKeeperServerTickTime;
    }

    public int getZooKeeperServerInitLimit() {
        return this.zooKeeperServerInitLimit;
    }

    public int getZooKeeperServerSyncLimit() {
        return this.zooKeeperServerSyncLimit;
    }

    public String getZooKeeperServerDataDir() {
        return this.zooKeeperServerDataDir;
    }

    public String getZookeeperPassword() {
        return this.zookeeperPassword;
    }

    public boolean isEnsembleStart() {
        return this.ensembleStart;
    }

    public boolean isAgentEnabled() {
        return this.agentEnabled;
    }

    public boolean isAutoImportEnabled() {
        return this.autoImportEnabled;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public boolean isWaitForProvision() {
        return this.waitForProvision;
    }

    public long getBootstrapTimeout() {
        return this.bootstrapTimeout;
    }

    public long getMigrationTimeout() {
        return this.migrationTimeout;
    }

    public boolean isClean() {
        return this.clean;
    }

    public String toString() {
        return super.toString() + " CreateEnsembleOptions{" + "zooKeeperServerPort=" + this.zooKeeperServerPort + ", zookeeperPassword='" + this.zookeeperPassword + '\'' + ", agentEnabled=" + this.agentEnabled + ", autoImportEnabled=" + this.autoImportEnabled + ", importPath='" + this.importPath + '\'' + ", users=" + this.users + '}';
    }

    public static String generatePassword() {
        StringBuilder password = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            long l = Math.round(Math.floor(Math.random() * 62.0));
            if (l < 10L) {
                password.append((char)(48L + l));
                continue;
            }
            if (l < 36L) {
                password.append((char)(65L + l - 10L));
                continue;
            }
            password.append((char)(97L + l - 36L));
        }
        return password.toString();
    }
}

