/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery;

import io.narayana.openshift.txrecovery.ApplicationRecoveryPodHibernate4DAO;
import io.narayana.openshift.txrecovery.cliargs.ParsedArguments;
import io.narayana.openshift.txrecovery.hibernate.ApplicationRecoveryPod;
import io.narayana.openshift.txrecovery.main.ProcessorMethods;
import io.narayana.openshift.txrecovery.types.CommandType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;

public class Hibernate4ProcessorMethods
implements ProcessorMethods {
    private static final Logger log = Logger.getLogger(Hibernate4ProcessorMethods.class);
    private static final List<String> EMPTY_RETURN = Collections.unmodifiableList(new ArrayList());
    private ApplicationRecoveryPodHibernate4DAO dao;
    private ParsedArguments parsedArguments;

    public Hibernate4ProcessorMethods(ApplicationRecoveryPodHibernate4DAO dao, ParsedArguments parsedArguments) {
        this.dao = dao;
        this.parsedArguments = parsedArguments;
    }

    public List<String> create() {
        return EMPTY_RETURN;
    }

    public List<String> insert() {
        String recPod;
        String appPod = this.parsedArguments.getApplicationPodName();
        if (!this.dao.saveRecord(appPod, recPod = this.parsedArguments.getRecoveryPodName())) {
            throw new IllegalStateException("Error on saving data [" + appPod + "," + recPod + "] to db " + this.parsedArguments.getJdbcUrl() + " and table " + this.parsedArguments.getTableName());
        }
        return EMPTY_RETURN;
    }

    public List<String> delete() {
        String appPod = this.parsedArguments.getApplicationPodName();
        String recPod = this.parsedArguments.getRecoveryPodName();
        int numberDeleted = this.dao.delete(appPod, recPod);
        log.info((Object)("Number [" + numberDeleted + "] of records deleted while filtered at [application pod: " + appPod + ", recovery pod: " + recPod + "]"));
        return EMPTY_RETURN;
    }

    public List<String> selectApplication() {
        String appPod = this.parsedArguments.getApplicationPodName();
        String recPod = this.parsedArguments.getRecoveryPodName();
        ArrayList<String> outputListing = new ArrayList<String>();
        Collection<ApplicationRecoveryPod> dtos = this.dao.getRecords(appPod, recPod);
        for (ApplicationRecoveryPod dto : dtos) {
            if (this.parsedArguments.getCommand() == CommandType.SELECT_APPLICATION) {
                outputListing.add(dto.getApplicationPodName());
            }
            if (this.parsedArguments.getCommand() != CommandType.SELECT_RECOVERY) continue;
            outputListing.add(dto.getRecoveryPodName());
        }
        return outputListing;
    }

    public List<String> selectRecovery() {
        return this.selectApplication();
    }
}

