/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery;

import io.narayana.openshift.txrecovery.ApplicationRecoveryPodHibernate4DAO;
import io.narayana.openshift.txrecovery.Hibernate4ProcessorMethods;
import io.narayana.openshift.txrecovery.cliargs.ArgumentParserException;
import io.narayana.openshift.txrecovery.cliargs.ParsedArguments;
import io.narayana.openshift.txrecovery.hibernate.ApplicationRecoveryPod;
import io.narayana.openshift.txrecovery.hibernate.HibernateProperties;
import io.narayana.openshift.txrecovery.main.OutputPrinter;
import io.narayana.openshift.txrecovery.main.ProcessorMethods;
import io.narayana.openshift.txrecovery.main.ProgramProcessor;
import io.narayana.openshift.txrecovery.types.OutputFormatType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.DefaultNamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.jboss.logging.Logger;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class);

    public static void main(String[] args) {
        ParsedArguments parsedArguments = null;
        try {
            parsedArguments = ParsedArguments.parse((String[])args);
        }
        catch (ArgumentParserException ape) {
            log.debugf((Throwable)ape, "Error on parsing arguments: %s", Arrays.asList(args));
            System.exit(1);
        }
        Properties setupProperties = HibernateProperties.setupPropertiesByParsedArguments((ParsedArguments)parsedArguments);
        setupProperties.setProperty("hibernate.hbm2ddl.auto", "update");
        final String tableName = HibernateProperties.getTableName((Properties)setupProperties);
        Configuration configuration = new Configuration().addAnnotatedClass(ApplicationRecoveryPod.class).addProperties(setupProperties).setNamingStrategy((NamingStrategy)new DefaultNamingStrategy(){
            private static final long serialVersionUID = 1L;

            public String tableName(String originalTableName) {
                if (originalTableName.equalsIgnoreCase("RECOVERY_MARKER") && tableName != null && !tableName.isEmpty()) {
                    return tableName;
                }
                return originalTableName;
            }
        });
        ServiceRegistry builder = new ServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).buildServiceRegistry();
        SessionFactory sessionFactory = configuration.buildSessionFactory(builder);
        Session session = sessionFactory.openSession();
        ApplicationRecoveryPodHibernate4DAO dao = new ApplicationRecoveryPodHibernate4DAO(session);
        Hibernate4ProcessorMethods methods = new Hibernate4ProcessorMethods(dao, parsedArguments);
        List outputListing = new ProgramProcessor((ProcessorMethods)methods).process(parsedArguments);
        OutputPrinter.printToStandardOutput((List)outputListing, (OutputFormatType)parsedArguments.getFormat());
    }
}

