/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.actions.jaxrs;

import io.nessus.actions.core.NessusConfig;
import io.nessus.actions.core.jaxrs.AbstractApplication;
import io.nessus.actions.jaxrs.ModelResource;
import io.nessus.actions.jaxrs.ModelsResource;
import io.nessus.actions.jaxrs.UserResource;
import io.nessus.actions.jaxrs.UsersResource;
import io.nessus.common.Config;
import io.nessus.h2.ConnectionFactory;
import io.nessus.h2.DBUtils;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import java.sql.Connection;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@OpenAPIDefinition(info=@Info(title="Fuse TryIt - Jaxrs API", version="1.0.0"), externalDocs=@ExternalDocumentation(url="https://github.com/tdiesler/nessus-actions"))
public class JaxrsApplication
extends AbstractApplication {
    public JaxrsApplication(NessusConfig config) throws Exception {
        super(config);
        ConnectionFactory factory = new ConnectionFactory((Config)config);
        try (Connection con = factory.createConnection(Duration.ofSeconds(20L));){
            DBUtils.createDatabase((Connection)con, (String)"initdb.sql");
        }
    }

    public Set<Class<?>> getClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(ModelResource.class);
        classes.add(ModelsResource.class);
        classes.add(UsersResource.class);
        classes.add(UserResource.class);
        return Collections.unmodifiableSet(classes);
    }
}

