/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.actions.jaxrs;

import io.nessus.actions.core.NessusConfig;
import io.nessus.actions.core.jaxrs.AbstractUserResource;
import io.nessus.actions.core.types.KeycloakUserInfo;
import io.nessus.actions.core.types.MavenBuildHandle;
import io.nessus.actions.core.utils.ApiUtils;
import io.nessus.actions.jaxrs.service.MavenBuilderService;
import io.nessus.actions.jaxrs.service.UserModelService;
import io.nessus.actions.jaxrs.type.UserModel;
import io.nessus.common.AssertState;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/user/{userId}/model")
@SecurityScheme(type=SecuritySchemeType.OPENIDCONNECT, scheme="Bearer")
public class ModelResource
extends AbstractUserResource {
    @GET
    @Path(value="/{modelId}")
    @Operation(summary="Get the model for the given id.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="[OK] Model for the given id could be accessed.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserModel.class))}), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided access token was not valid."), @ApiResponse(responseCode="404", description="[Not Found] The model for the given id could not be found.")})
    public Response getModel(@PathParam(value="userId") String userId, @PathParam(value="modelId") String modelId) {
        this.logInfo("Get model: {}", new Object[]{modelId});
        KeycloakUserInfo kcinfo = this.getKeycloakUserInfo(userId);
        if (kcinfo == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserModelService models = (UserModelService)this.getService(UserModelService.class);
        UserModel userModel = models.findModel(modelId);
        if (userModel == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().type("application/json").entity((Object)userModel).build();
    }

    @POST
    @Path(value="/{modelId}")
    @Consumes(value={"application/json"})
    @Operation(summary="Update the given model.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="[OK] Successfully updated the model."), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided access token was not valid.")})
    public Response updateModel(@PathParam(value="userId") String userId, @PathParam(value="modelId") String modelId, UserModel userModel) {
        this.logInfo("Update model: {}", new Object[]{userModel.modelId});
        KeycloakUserInfo kcinfo = this.getKeycloakUserInfo(userId);
        if (kcinfo == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        AssertState.isEqual((Object)modelId, (Object)userModel.modelId);
        UserModelService models = (UserModelService)this.getService(UserModelService.class);
        userModel = models.updateModel(userModel);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{modelId}")
    @Operation(summary="Delete the model with the given id.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="[No Content] Successfully deleted the model."), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided access token was not valid.")})
    public Response deleteModel(@PathParam(value="userId") String userId, @PathParam(value="modelId") String modelId) {
        this.logInfo("Delete model: {}", new Object[]{modelId});
        KeycloakUserInfo kcinfo = this.getKeycloakUserInfo(userId);
        if (kcinfo == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserModelService models = (UserModelService)this.getService(UserModelService.class);
        models.deleteModel(modelId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/{modelId}/{runtime}/build")
    @Operation(summary="Schedule the build process for the model.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="[OK] Successfully scheduled the model build."), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided access token was not valid."), @ApiResponse(responseCode="404", description="[Not Found] The model for the given id could not be found.")})
    public Response buildModel(@PathParam(value="userId") String userId, @PathParam(value="modelId") String modelId, @PathParam(value="runtime") String runtime) {
        this.logInfo("Schedule model build: {}", new Object[]{modelId});
        KeycloakUserInfo kcinfo = this.getKeycloakUserInfo(userId);
        if (kcinfo == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserModelService models = (UserModelService)this.getService(UserModelService.class);
        UserModel userModel = models.findModel(modelId);
        if (userModel == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        MavenBuilderService maven = (MavenBuilderService)this.getService(MavenBuilderService.class);
        Response res = maven.buildModelWithMaven(kcinfo, userModel, runtime);
        if (!ApiUtils.hasStatus((Response)res, (Response.Status[])new Response.Status[]{Response.Status.OK})) {
            return res;
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{modelId}/{runtime}/status")
    @Operation(summary="Get the current build status")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="[OK] Found the status for the requested project.", content={@Content(mediaType="application/json", schema=@Schema(implementation=MavenBuildHandle.class))}), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided credentials were not valid."), @ApiResponse(responseCode="404", description="[Not Found] The project for the given id was not found.")})
    public Response getBuildStatus(@PathParam(value="userId") String userId, @PathParam(value="modelId") String modelId, @PathParam(value="runtime") String runtime) {
        String projId = modelId + "/" + runtime;
        URI uri = ApiUtils.mavenUri((NessusConfig)((NessusConfig)this.getConfig()), (String)("/api/build/" + projId + "/status"));
        return Response.seeOther((URI)uri).build();
    }

    @GET
    @Path(value="/{modelId}/{runtime}/download")
    @Operation(summary="Download the build target")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="[OK] Found the requested build target.", content={@Content(mediaType="application/octet-stream")}), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided credentials were not valid."), @ApiResponse(responseCode="404", description="[Not Found] The target file was not found.")})
    public Response downloadBuildTarget(@PathParam(value="userId") String userId, @PathParam(value="modelId") String modelId, @PathParam(value="runtime") String runtime) {
        String projId = modelId + "/" + runtime;
        URI uri = ApiUtils.mavenUri((NessusConfig)((NessusConfig)this.getConfig()), (String)("/api/build/" + projId + "/download"));
        return Response.seeOther((URI)uri).build();
    }
}

