/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.actions.jaxrs;

import io.nessus.actions.core.jaxrs.AbstractUserResource;
import io.nessus.actions.core.types.KeycloakUserInfo;
import io.nessus.actions.jaxrs.service.UserModelService;
import io.nessus.actions.jaxrs.type.UserModel;
import io.nessus.actions.jaxrs.type.UserModelAdd;
import io.nessus.actions.jaxrs.type.UserModelList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/user/{userId}/models")
public class ModelsResource
extends AbstractUserResource {
    @PUT
    @Consumes(value={"application/json"})
    @Operation(summary="Create a new integration model")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="[Created] Model was successfully created.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserModel.class))}), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided access token was not valid.")})
    public Response createModel(@PathParam(value="userId") String userId, UserModelAdd modelAdd) {
        this.logInfo("Create model: {}", new Object[]{modelAdd});
        KeycloakUserInfo kcinfo = this.getKeycloakUserInfo(userId);
        if (kcinfo == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (!modelAdd.userId.equals(userId)) {
            this.logError("User id does not match", new Object[0]);
            return null;
        }
        UserModelService models = (UserModelService)this.getService(UserModelService.class);
        UserModel userModel = models.createModel(modelAdd);
        return Response.status((Response.Status)Response.Status.CREATED).type("application/json").entity((Object)userModel).build();
    }

    @GET
    @Operation(summary="Get the list of the given user's model ids.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="[OK] List of user model definitions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserModelList.class))}), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided access token was not valid.")})
    public Response getModels(@PathParam(value="userId") String userId) {
        this.logInfo("Get models for user: {}", new Object[]{userId});
        KeycloakUserInfo kcinfo = this.getKeycloakUserInfo(userId);
        if (kcinfo == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserModelService mdlsrv = (UserModelService)this.getService(UserModelService.class);
        List<UserModel> models = mdlsrv.findUserModels(userId);
        UserModelList userModels = new UserModelList(userId, models);
        return Response.ok().type("application/json").entity((Object)userModels).build();
    }
}

