/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.actions.jaxrs;

import io.nessus.actions.core.NessusConfig;
import io.nessus.actions.core.jaxrs.AbstractUserResource;
import io.nessus.actions.core.service.KeycloakService;
import io.nessus.actions.core.types.KeycloakUserInfo;
import io.nessus.actions.core.utils.ApiUtils;
import io.nessus.actions.jaxrs.service.UserStateService;
import io.nessus.actions.jaxrs.type.UserState;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import java.net.URI;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/user")
@SecurityScheme(type=SecuritySchemeType.OPENIDCONNECT, scheme="Bearer")
public class UserResource
extends AbstractUserResource {
    @GET
    @Path(value="/{userId}/state")
    @Operation(summary="Fetch the current state for the given user id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="[OK] Found the requested user state.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserState.class))}), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided access token was not valid.")})
    public Response getUserState(@PathParam(value="userId") String userId) {
        KeycloakUserInfo kcinfo = this.getKeycloakUserInfo(userId);
        if (kcinfo == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserStateService usrsvc = (UserStateService)this.getService(UserStateService.class);
        UserState userState = usrsvc.getOrCreateUserState(kcinfo);
        return Response.ok((Object)userState, (String)"application/json").build();
    }

    @DELETE
    @Path(value="/{userId}")
    @Operation(summary="Delete the user with the given id")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="[No Content] Sucessfully delete the user in Keycloak."), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided access token was not valid.")})
    public Response deleteUser(@PathParam(value="userId") String userId) {
        KeycloakUserInfo kcinfo = this.getKeycloakUserInfo(userId);
        if (kcinfo == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String realmId = ((NessusConfig)this.config).getKeycloakRealmId();
        KeycloakService keycloak = this.getKeycloakService();
        String masterToken = keycloak.getMasterAccessToken();
        URI uri = ApiUtils.keycloakUri((NessusConfig)((NessusConfig)this.config), (String)("/admin/realms/" + realmId + "/users/" + userId));
        Response res = this.withClient(uri, target -> target.request().header("Authorization", (Object)("Bearer " + masterToken)).delete());
        ApiUtils.hasStatus((Response)res, (Response.Status[])new Response.Status[]{Response.Status.NO_CONTENT});
        return res;
    }
}

