/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.actions.jaxrs;

import io.nessus.actions.core.NessusConfig;
import io.nessus.actions.core.jaxrs.AbstractResource;
import io.nessus.actions.core.service.KeycloakService;
import io.nessus.actions.core.types.KeycloakTokens;
import io.nessus.actions.core.types.KeycloakUserInfo;
import io.nessus.actions.core.utils.ApiUtils;
import io.nessus.actions.jaxrs.service.UserStateService;
import io.nessus.actions.jaxrs.type.UserRegister;
import io.nessus.actions.jaxrs.type.UserTokens;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

@Path(value="/users")
public class UsersResource
extends AbstractResource {
    @PUT
    @Consumes(value={"application/json"})
    @Operation(summary="Register a new user with Keycloak")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="[Created] User was successfully created to Keycloak."), @ApiResponse(responseCode="409", description="[Conflict] If the user already exists in Keycloak.")})
    public Response registerUser(UserRegister user) {
        this.logInfo("Register: {}", new Object[]{user.getEmail()});
        String realmId = ((NessusConfig)this.getConfig()).getKeycloakRealmId();
        KeycloakService keycloak = this.getKeycloakService();
        String accessToken = keycloak.getMasterAccessToken();
        URI uri = ApiUtils.keycloakUri((NessusConfig)((NessusConfig)this.config), (String)("/admin/realms/" + realmId + "/users"));
        Response res = this.withClient(uri, target -> target.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).post(Entity.json((Object)user.toKeycloakUserRegister())));
        ApiUtils.hasStatus((Response)res, (Response.Status[])new Response.Status[]{Response.Status.CREATED});
        return res;
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Login the user with Keycloak")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="[OK] Successful user login.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserTokens.class))}), @ApiResponse(responseCode="401", description="[Unauthorized] If the provided credentials were not valid.")})
    public Response userLogin(@FormParam(value="username") @Parameter(required=true) String username, @FormParam(value="password") @Parameter(required=true) String password) {
        this.logInfo("Login: {}", new Object[]{username});
        KeycloakService keycloak = this.getKeycloakService();
        Response res = keycloak.getUserTokens(username, password);
        if (!ApiUtils.hasStatus((Response)res, (Response.Status[])new Response.Status[]{Response.Status.OK})) {
            return res;
        }
        KeycloakTokens tokens = (KeycloakTokens)res.readEntity(KeycloakTokens.class);
        String refreshToken = tokens.refreshToken;
        String accessToken = tokens.accessToken;
        res = keycloak.getKeycloakUserInfo(accessToken);
        if (!ApiUtils.hasStatus((Response)res, (Response.Status[])new Response.Status[]{Response.Status.OK})) {
            return res;
        }
        KeycloakUserInfo kcinfo = (KeycloakUserInfo)res.readEntity(KeycloakUserInfo.class);
        UserTokens userTokens = new UserTokens(kcinfo.subject, accessToken, refreshToken);
        UserStateService usrsvc = (UserStateService)this.getService(UserStateService.class);
        usrsvc.userLogin(kcinfo);
        return Response.ok((Object)userTokens, (String)"application/json").build();
    }
}

