/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.actions.jaxrs.main;

import io.nessus.actions.core.NessusConfig;
import io.nessus.actions.core.service.KeycloakService;
import io.nessus.actions.jaxrs.JaxrsApplication;
import io.nessus.actions.jaxrs.main.JaxrsOptions;
import io.nessus.actions.jaxrs.service.DefaultMavenBuilderService;
import io.nessus.actions.jaxrs.service.UserModelService;
import io.nessus.actions.jaxrs.service.UserStateService;
import io.nessus.common.Config;
import io.nessus.common.main.AbstractMain;
import io.nessus.common.main.AbstractOptions;
import io.nessus.common.rest.JaxrsServer;
import io.nessus.common.rest.SSLContextBuilder;
import io.nessus.common.service.Service;
import io.nessus.h2.H2Config;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Application;

public class JaxrsMain
extends AbstractMain<NessusConfig, JaxrsOptions> {
    public static void main(String ... args) throws Exception {
        NessusConfig config = NessusConfig.createConfig();
        new JaxrsMain(config).start(args);
    }

    public JaxrsMain(NessusConfig config) throws IOException {
        super((Config)config);
        config.addService((Service)new DefaultMavenBuilderService(config));
        config.addService((Service)new KeycloakService(config));
        config.addService((Service)new UserModelService(config));
        config.addService((Service)new UserStateService(config));
    }

    protected JaxrsOptions createOptions() {
        return new JaxrsOptions();
    }

    protected void prepare(Map<String, String> mapping, JaxrsOptions options) {
        mapping.putAll(H2Config.PROPERTY_MAPPING);
        super.prepare(mapping, (AbstractOptions)options);
    }

    protected void doStart(JaxrsOptions options) throws Exception {
        String jaxrsUrl = ((NessusConfig)this.config).getJaxrsUrl();
        String jaxrsTLSUrl = ((NessusConfig)this.config).getJaxrsTLSUrl();
        boolean withTLS = this.isTLSEnabled();
        this.logInfo("***************************************************", new Object[0]);
        if (withTLS) {
            this.logInfo("Starting {}", new Object[]{jaxrsTLSUrl});
        }
        this.logInfo("Starting {}", new Object[]{jaxrsUrl});
        this.logInfo("Version {}", new Object[]{JaxrsMain.getVersionString()});
        this.logInfo("***************************************************", new Object[0]);
        this.logInfo();
        JaxrsServer server = this.createJaxrsServer(withTLS);
        server.start();
    }

    public JaxrsServer createJaxrsServer() throws Exception {
        return this.createJaxrsServer(this.isTLSEnabled());
    }

    private JaxrsServer createJaxrsServer(boolean withTLS) throws Exception {
        URL url = new URL(((NessusConfig)this.config).getJaxrsUrl());
        String host = "0.0.0.0";
        int port = url.getPort();
        JaxrsServer server = new JaxrsServer(this.getConfig()).withHostname(host).withHttpPort(port);
        if (withTLS) {
            String alias = "nessus-actions-jaxrs";
            Path tlsKey = Paths.get(((NessusConfig)this.config).getTLSKey(), new String[0]);
            Path tlsCrt = Paths.get(((NessusConfig)this.config).getTLSCrt(), new String[0]);
            SSLContext sslContext = new SSLContextBuilder().keystorePath(Paths.get("/tmp/keystore.jks", new String[0])).addCertificate(alias, tlsCrt).addPrivateKey(alias, tlsKey).build();
            SSLContext.setDefault(sslContext);
            URL tlsUrl = new URL(((NessusConfig)this.config).getJaxrsTLSUrl());
            int tlsPort = tlsUrl.getPort();
            server.withHttpsPort(tlsPort, sslContext);
        }
        server.deploy("/jaxrs/api", (Application)new JaxrsApplication((NessusConfig)this.getConfig()));
        return server;
    }

    private boolean isTLSEnabled() {
        String tlsUrl = ((NessusConfig)this.config).getJaxrsTLSUrl();
        String tlsCert = ((NessusConfig)this.config).getTLSCrt();
        String tlsKey = ((NessusConfig)this.config).getTLSKey();
        if (tlsUrl == null || tlsCert == null || tlsKey == null) {
            return false;
        }
        if (!Paths.get(tlsCert, new String[0]).toFile().isFile()) {
            this.logError("Cannot find TLS Cert: {}", new Object[]{tlsCert});
            return false;
        }
        if (!Paths.get(tlsKey, new String[0]).toFile().isFile()) {
            this.logError("Cannot find TLS Key: {}", new Object[]{tlsKey});
            return false;
        }
        this.logInfo("TLS URL: {}", new Object[]{tlsUrl});
        this.logInfo("TLS Crt: {}", new Object[]{tlsCert});
        this.logInfo("TLS Key: {}", new Object[]{tlsKey});
        this.logInfo("TLS Enabled", new Object[0]);
        return true;
    }
}

