/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.actions.jaxrs.service;

import io.nessus.actions.core.NessusConfig;
import io.nessus.actions.core.service.AbstractService;
import io.nessus.common.BasicConfig;
import io.nessus.common.CheckedExceptionWrapper;
import io.nessus.h2.ConnectionFactory;
import java.sql.Connection;

class AbstractJaxrsService
extends AbstractService<NessusConfig> {
    AbstractJaxrsService(NessusConfig config) {
        super((BasicConfig)config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R> R withConnection(CheckedFunction<Connection, R> function) {
        ConnectionFactory factory = new ConnectionFactory(this.config);
        try (Connection con = factory.createConnection();){
            R r = function.apply(con);
            return r;
        }
        catch (Exception ex) {
            throw CheckedExceptionWrapper.create((Throwable)ex);
        }
    }

    static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

