/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.actions.jaxrs.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.nessus.actions.jaxrs.type.UserModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class UserModelList {
    public final String userId;
    public final List<UserModel> models = new ArrayList<UserModel>();

    @JsonCreator
    public UserModelList(@JsonProperty(value="userId", required=true) String userId, @JsonProperty(value="models") List<UserModel> models) {
        this.userId = userId;
        if (models != null) {
            this.models.addAll(models);
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.models.isEmpty();
    }

    @JsonIgnore
    public int size() {
        return this.models.size();
    }

    public String getUserId() {
        return this.userId;
    }

    public List<UserModel> getModels() {
        return Collections.unmodifiableList(this.models);
    }

    public static enum ModelRuntime {
        standalone,
        docker,
        kubernetes,
        eap;

    }
}

