/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.h2;

import io.nessus.common.AssertArg;
import io.nessus.common.Config;
import io.nessus.h2.DBServer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionFactory {
    private static Logger LOG = LoggerFactory.getLogger(ConnectionFactory.class);
    private static final ThreadLocal<Connection> threadLocal = new ThreadLocal();
    private final Config config;
    private static boolean firstTime = true;

    public ConnectionFactory(Config config) {
        this.config = config;
    }

    public Connection createConnection() throws SQLException {
        Connection con = threadLocal.get();
        AssertArg.isTrue((Boolean)(con == null ? 1 : 0), (String)"Connection already created by this thread");
        DBServer.initConfig(LOG, this.config);
        String jdbcServerUrl = (String)this.config.getParameter("jdbcServerUrl", String.class);
        String jdbcUrl = (String)this.config.getParameter("jdbcUrl", String.class);
        String jdbcUser = (String)this.config.getParameter("jdbcUser", String.class);
        String jdbcPass = (String)this.config.getParameter("jdbcPass", (Object)"");
        if (firstTime) {
            if (jdbcServerUrl != null) {
                LOG.debug(String.format("jdbcServerUrl:  %s", jdbcServerUrl));
            }
            LOG.debug(String.format("jdbcUrl:  %s", jdbcUrl));
            LOG.debug(String.format("jdbcUser: %s", jdbcUser));
            LOG.debug(String.format("jdbcPass: %s", jdbcPass.length() > 0 ? "*******" : ""));
            firstTime = false;
        }
        con = DriverManager.getConnection(jdbcUrl, jdbcUser, jdbcPass);
        AssertArg.notNull((Object)con, (String)"Cannot obtain connection");
        ConnectionWrapper wrapper = new ConnectionWrapper(con);
        threadLocal.set(wrapper);
        return wrapper;
    }

    public boolean hasConnection() {
        return threadLocal.get() != null;
    }

    public Connection getConnection() {
        return threadLocal.get();
    }

    public class ConnectionWrapper
    implements Connection {
        final Connection con;

        private ConnectionWrapper(Connection con) {
            this.con = con;
        }

        @Override
        public void close() throws SQLException {
            threadLocal.remove();
            this.con.close();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.con.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.con.isWrapperFor(iface);
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.con.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.con.prepareStatement(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.con.prepareCall(sql);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.con.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.con.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.con.getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            this.con.commit();
        }

        @Override
        public void rollback() throws SQLException {
            this.con.rollback();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.con.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.con.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.con.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.con.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.con.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.con.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.con.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.con.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.con.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.con.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.con.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.con.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.con.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.con.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.con.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.con.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.con.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.con.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.con.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.con.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.con.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.con.prepareStatement(sql, columnNames);
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.con.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.con.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.con.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.con.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.con.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.con.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.con.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.con.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.con.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.con.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.con.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.con.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.con.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.con.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.con.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.con.getNetworkTimeout();
        }
    }
}

