/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common.testing;

import io.nessus.common.BasicConfig;
import io.nessus.common.CheckedExceptionWrapper;
import io.nessus.common.Config;
import io.nessus.common.LogSupport;
import io.nessus.common.Parameters;
import io.nessus.common.service.BasicLogService;
import io.nessus.common.service.Service;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractTest<T extends Config>
extends LogSupport {
    private T config;

    @Before
    public void before() throws Exception {
    }

    @After
    public void after() throws Exception {
        if (this.config != null) {
            this.config.closeServices();
        }
    }

    protected <S extends Service> S getService(Class<S> type) {
        return this.getConfig().getService(type);
    }

    protected String getSimpleName() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith("Test")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    protected Path getOutPath() {
        Path outdir = Paths.get("target", this.getSimpleName());
        outdir.toFile().mkdirs();
        return outdir;
    }

    protected PrintStream getPrintStream() throws IOException {
        return this.getPrintStream(this.getSimpleName());
    }

    protected PrintStream getPrintStream(String fname) throws IOException {
        File file = Paths.get("target", fname + ".txt").toFile();
        return new PrintStream(new FileOutputStream(file));
    }

    protected T createConfig() throws Exception {
        BasicConfig config = new BasicConfig(new Parameters());
        config.addService(new BasicLogService());
        return (T)config;
    }

    public T getConfig() {
        if (this.config == null) {
            try {
                this.config = this.createConfig();
            }
            catch (Exception ex) {
                throw CheckedExceptionWrapper.create(ex);
            }
            this.config.initServices();
        }
        return this.config;
    }

    protected void sleepSafe(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

