/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs;

import io.ipfs.multihash.Multihash;
import io.nessus.Wallet;
import io.nessus.cipher.utils.AESUtils;
import io.nessus.ipfs.AbstractHandle;
import io.nessus.ipfs.CidPath;
import io.nessus.utils.AssertArgument;
import java.security.Key;
import java.security.PublicKey;

public class AHandle
extends AbstractHandle {
    final PublicKey pubKey;

    private AHandle(Wallet.Address addr, PublicKey pubKey, CidPath cid, String txId, boolean expired, int attempt, long elapsed) {
        super(addr, cid, txId, pubKey != null, expired, attempt, elapsed);
        this.pubKey = pubKey;
    }

    public PublicKey getPubKey() {
        return this.pubKey;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.owner.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AHandle)) {
            return false;
        }
        AHandle other = (AHandle)obj;
        return this.owner.equals(other.owner);
    }

    public String toString() {
        String addr = this.owner.getAddress();
        String keystr = this.pubKey != null ? AESUtils.encodeKey((Key)this.pubKey).substring(0, 8) : null;
        return String.format("[addr=%s, cid=%s, key=%s, avl=%d, exp=%d, try=%d, time=%s]", addr, this.cid, keystr, this.available ? 1 : 0, this.expired ? 1 : 0, this.attempt, this.elapsed);
    }

    public static class AHBuilder
    extends AbstractHandle.AbstractBuilder<AHBuilder, AbstractHandle> {
        private PublicKey pubKey;

        public AHBuilder(Wallet.Address owner, PublicKey pubKey) {
            super(owner);
            AssertArgument.assertNotNull((Object)pubKey, (String)"Null pubKey");
            this.pubKey = pubKey;
        }

        public AHBuilder(Wallet.Address owner, String txId, Multihash cid) {
            super(owner, txId, cid);
        }

        public AHBuilder(AHandle ahandle) {
            super(ahandle);
            this.pubKey = ahandle.pubKey;
        }

        public AHBuilder pubKey(PublicKey pubKey) {
            this.pubKey = pubKey;
            return this;
        }

        @Override
        public AHandle build() {
            AHandle ahandle = new AHandle(this.owner, this.pubKey, this.cid, this.txId, this.expired, this.attempt, this.elapsed);
            return ahandle;
        }
    }
}

