/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs;

import io.ipfs.multihash.Multihash;
import io.nessus.Wallet;
import io.nessus.ipfs.CidPath;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.util.List;

public class AbstractHandle {
    protected final Wallet.Address owner;
    protected final CidPath cid;
    protected final String txId;
    protected final boolean available;
    protected final boolean expired;
    protected final int attempt;
    protected final long elapsed;

    protected AbstractHandle(Wallet.Address owner, CidPath cid, String txId, boolean available, boolean expired, int attempt, long elapsed) {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        this.owner = owner;
        this.cid = cid;
        this.txId = txId;
        this.available = available;
        this.expired = expired;
        this.attempt = attempt;
        this.elapsed = elapsed;
        List labels = owner.getLabels();
        AssertState.assertTrue((Boolean)(labels.size() < 2 ? 1 : 0), (String)("Multiple labels: " + labels));
    }

    public Multihash getCid() {
        if (this.cid == null) {
            return null;
        }
        if (this.cid.getPath() != null) {
            return null;
        }
        return this.cid.getCid();
    }

    public CidPath getCidPath() {
        return this.cid;
    }

    public Wallet.Address getOwner() {
        return this.owner;
    }

    public String getLabel() {
        return (String)this.owner.getLabels().get(0);
    }

    public String getTxId() {
        return this.txId;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public boolean isMissing() {
        return !this.available && !this.expired;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.owner.hashCode();
        result = 31 * result + (this.cid == null ? 0 : this.cid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.cid == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractHandle other = (AbstractHandle)obj;
        return this.owner.equals(other.owner) && this.cid.equals(other.cid);
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<?, ?>, T extends AbstractHandle> {
        protected Wallet.Address owner;
        protected CidPath cid;
        protected String txId;
        protected boolean expired;
        protected int attempt;
        protected long elapsed;

        protected AbstractBuilder(Wallet.Address owner) {
            AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
            this.owner = owner;
        }

        protected AbstractBuilder(Wallet.Address owner, String txId, Multihash cid) {
            AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
            AssertArgument.assertNotNull((Object)txId, (String)"Null txId");
            AssertArgument.assertNotNull((Object)cid, (String)"Null cid");
            this.cid = new CidPath(cid);
            this.owner = owner;
            this.txId = txId;
        }

        protected AbstractBuilder(T handle) {
            AssertArgument.assertNotNull(handle, (String)"Null handle");
            this.owner = ((AbstractHandle)handle).owner;
            this.cid = ((AbstractHandle)handle).cid;
            this.txId = ((AbstractHandle)handle).txId;
            this.expired = ((AbstractHandle)handle).expired;
            this.attempt = ((AbstractHandle)handle).attempt;
            this.elapsed = ((AbstractHandle)handle).elapsed;
        }

        public B owner(Wallet.Address owner) {
            this.owner = owner;
            return (B)this;
        }

        public B cid(Multihash cid) {
            this.cid = cid != null ? new CidPath(cid) : null;
            return (B)this;
        }

        public B txId(String txId) {
            this.txId = txId;
            return (B)this;
        }

        public B expired(boolean expired) {
            this.expired = expired;
            return (B)this;
        }

        public B attempt(int attempt) {
            this.attempt = attempt;
            return (B)this;
        }

        public B elapsed(long elapsed) {
            this.elapsed = elapsed;
            return (B)this;
        }

        public abstract T build();
    }
}

