/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs;

import io.ipfs.multihash.Multihash;
import io.nessus.utils.AssertArgument;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class CidPath {
    private final Multihash cid;
    private final Path path;
    private final String cidSpec;

    public CidPath(Multihash cid) {
        this(cid, null);
    }

    public CidPath(Multihash cid, Path path) {
        AssertArgument.assertNotNull((Object)cid, (String)"Null cid");
        this.cid = cid;
        this.path = path;
        this.cidSpec = cid.toBase58() + (path != null ? "/" + path : "");
    }

    public CidPath append(String apath) {
        AssertArgument.assertNotNull((Object)apath, (String)"Null apath");
        Path xpath = this.path != null ? this.path.resolve(apath) : Paths.get(apath, new String[0]);
        return new CidPath(this.cid, xpath);
    }

    public Multihash getCid() {
        return this.cid;
    }

    public Path getPath() {
        return this.path;
    }

    public static CidPath parse(String cidPath) {
        CidPath result;
        int idx = cidPath.indexOf(47);
        if (idx > 0) {
            Multihash cid = Multihash.fromBase58((String)cidPath.substring(0, idx));
            Path path = Paths.get(cidPath.substring(idx), new String[0]);
            result = new CidPath(cid, path);
        } else {
            Multihash cid = Multihash.fromBase58((String)cidPath);
            result = new CidPath(cid, null);
        }
        return result;
    }

    public int hashCode() {
        return this.cidSpec.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CidPath)) {
            return false;
        }
        CidPath other = (CidPath)obj;
        return this.cidSpec.equals(other.cidSpec);
    }

    public String toString() {
        return this.cidSpec;
    }
}

