/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs;

import io.nessus.ipfs.core.AbstractConfig;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.kohsuke.args4j.Option;

public class ContentManagerConfig
extends AbstractConfig {
    public static final long DEFAULT_IPFS_TIMEOUT = 6000L;
    public static final int DEFAULT_IPFS_ATTEMPTS = 100;
    public static final int DEFAULT_IPFS_THREADS = 24;
    @Option(name="--ipfs-timeout", usage="The maximum number of millis for IPFS operations")
    protected long ipfsTimeout = 6000L;
    @Option(name="--ipfs-attempts", usage="The max number of IPFS operation attempts")
    protected int ipfsAttempts = 100;
    @Option(name="--ipfs-threads", usage="The number of threads for IPFS operations")
    protected int ipfsThreads = 24;
    @Option(name="--datadir", usage="The location of the internal data directory")
    protected Path dataDir = Paths.get(System.getProperty("user.home"), ".nessus");
    @Option(name="--overwrite", usage="Whether to overwrite existing files")
    protected boolean overwrite;

    public ContentManagerConfig() {
    }

    protected ContentManagerConfig(String bcImpl, String bcUrl, String bcHost, int bcPort, String bcUser, String bcPass, String ipfsAddr, long ipfsTimeout, int ipfsAttempts, int ipfsThreads, Path dataDir, boolean overwrite) {
        super(ipfsAddr, bcImpl, bcUrl, bcHost, bcPort, bcUser, bcPass);
        this.ipfsTimeout = ipfsTimeout;
        this.ipfsAttempts = ipfsAttempts;
        this.ipfsThreads = ipfsThreads;
        this.overwrite = overwrite;
        if (dataDir != null) {
            this.dataDir = dataDir;
        }
    }

    public long getIpfsTimeout() {
        return this.ipfsTimeout;
    }

    public int getIpfsAttempts() {
        return this.ipfsAttempts;
    }

    public int getIpfsThreads() {
        return this.ipfsThreads;
    }

    public Path getDataDir() {
        return this.dataDir;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public String toString() {
        return String.format("[dataDir=%s, timeout=%s, attempts=%s, threads=%s, overwrite=%b]", this.dataDir, this.ipfsTimeout, this.ipfsAttempts, this.ipfsThreads, this.overwrite);
    }

    protected static class AbstractContentManagerConfigBuilder<B extends AbstractContentManagerConfigBuilder<?, ?>, C extends ContentManagerConfig>
    extends AbstractConfig.AbstractConfigBuilder<B, C> {
        protected long ipfsTimeout = 6000L;
        protected int ipfsAttempts = 100;
        protected int ipfsThreads = 24;
        protected boolean overwrite;
        protected Path dataDir;

        protected AbstractContentManagerConfigBuilder() {
        }

        public B datadir(Path dataDir) {
            this.dataDir = dataDir;
            return (B)this;
        }

        public B overwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return (B)this;
        }

        public B ipfsTimeout(long timeout) {
            this.ipfsTimeout = timeout;
            return (B)this;
        }

        public B ipfsAttempts(int attempts) {
            this.ipfsAttempts = attempts;
            return (B)this;
        }

        public B ipfsThreads(int threads) {
            this.ipfsThreads = threads;
            return (B)this;
        }
    }

    public static class ContentManagerConfigBuilder
    extends AbstractContentManagerConfigBuilder<ContentManagerConfigBuilder, ContentManagerConfig> {
        public ContentManagerConfig build() {
            return new ContentManagerConfig(this.bcImpl, this.bcUrl, this.bcHost, this.bcPort, this.bcUser, this.bcPass, this.ipfsAddr, this.ipfsTimeout, this.ipfsAttempts, this.ipfsThreads, this.dataDir, this.overwrite);
        }
    }
}

