/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.core;

import io.ipfs.multihash.Multihash;
import io.nessus.Tx;
import io.nessus.TxOutput;
import io.nessus.UTXO;
import io.nessus.Wallet;
import io.nessus.ipfs.AHandle;
import io.nessus.ipfs.AbstractHandle;
import io.nessus.ipfs.FHandle;
import io.nessus.ipfs.core.DefaultContentManager;
import io.nessus.ipfs.core.FHeaderValues;
import io.nessus.ipfs.core.IPFSCache;
import io.nessus.ipfs.core.TxDataHandler;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHandleManager<T extends AbstractHandle> {
    final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected final DefaultContentManager cntmgr;
    protected final TxDataHandler dataHandler;
    protected final Executor executor;
    private static ExecutorService executorService;

    AbstractHandleManager(DefaultContentManager cntmgr) {
        this.cntmgr = cntmgr;
        if (executorService == null) {
            int ipfsThreads = cntmgr.getConfig().getIpfsThreads();
            executorService = Executors.newFixedThreadPool(ipfsThreads, new ThreadFactory(){
                AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable run) {
                    return new Thread(run, "ipfs-pool-" + this.count.incrementAndGet());
                }
            });
        }
        FHeaderValues fhvals = cntmgr.getFHeaderValues();
        this.dataHandler = new TxDataHandler(fhvals);
        this.executor = new Executor();
    }

    List<T> findContentAsync(Wallet.Address owner, WorkerFactory<T> factory, long timeout) {
        Class<T> type = factory.getType();
        List<T> handles = this.listUnspentHandles(owner, type);
        Future<Integer> future = this.executor.process(owner, handles, factory, timeout);
        int missing = -1;
        try {
            missing = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            this.LOG.error("{} error", (Object)this.getLogPrefix(type), (Object)ex);
        }
        catch (TimeoutException ex) {
            // empty catch block
        }
        if (missing > 0) {
            this.LOG.error("{} still missing: {}", (Object)this.getLogPrefix(type), (Object)missing);
        }
        List<Multihash> cids = this.getCids(handles);
        List<T> result = this.getCurrentHandles(cids, type);
        return result;
    }

    public T getUnspentHandle(Wallet.Address owner, Multihash cid, Class<T> type) {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)cid, (String)"Null cid");
        AbstractHandle handle = this.listUnspentHandles(owner, type).stream().filter(fh -> cid.equals((Object)fh.getCid())).findFirst().orElse(null);
        return (T)handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> listUnspentHandles(Wallet.Address owner, Class<T> type) {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        ArrayList<T> unspentFHandles = new ArrayList<T>();
        IPFSCache ipfsCache = this.cntmgr.getIPFSCache();
        Wallet wallet = this.cntmgr.getBlockchain().getWallet();
        IPFSCache iPFSCache = ipfsCache;
        synchronized (iPFSCache) {
            List<UTXO> locked = this.listLockedAndUnlockedUnspent(owner, true, false);
            List<UTXO> unspent = this.listLockedAndUnlockedUnspent(owner, true, true);
            for (UTXO utxo : unspent) {
                String txId = utxo.getTxId();
                Tx tx = wallet.getTransaction(txId);
                T txhdl = this.getHandleFromTx(owner, utxo);
                if (txhdl == null) continue;
                Multihash cid = ((AbstractHandle)txhdl).getCid();
                T fhaux = ipfsCache.get(cid, type);
                if (fhaux == null) {
                    ipfsCache.put((AbstractHandle)txhdl);
                    fhaux = txhdl;
                }
                unspentFHandles.add(fhaux);
                if (locked.contains(utxo) || owner.getPrivKey() == null) continue;
                int vout = tx.outputs().size() - 2;
                TxOutput dataOut = (TxOutput)tx.outputs().get(vout);
                AssertState.assertEquals((Object)owner.getAddress(), (Object)dataOut.getAddress());
                wallet.lockUnspent(utxo, false);
            }
            List unspentIds = unspentFHandles.stream().map(fh -> fh.getCid()).collect(Collectors.toList());
            for (Multihash cid : new HashSet<Multihash>(ipfsCache.keySet(FHandle.class))) {
                if (unspentIds.contains(cid)) continue;
                ipfsCache.remove(cid, AbstractHandle.class);
            }
        }
        return unspentFHandles;
    }

    abstract T getHandleFromTx(Wallet.Address var1, UTXO var2);

    boolean isOurs(Tx tx) {
        List outs = tx.outputs();
        if (outs.size() < 2) {
            return false;
        }
        TxOutput out0 = (TxOutput)outs.get(outs.size() - 2);
        TxOutput out1 = (TxOutput)outs.get(outs.size() - 1);
        Wallet wallet = this.cntmgr.getBlockchain().getWallet();
        Wallet.Address addr = wallet.findAddress(out0.getAddress());
        if (addr == null) {
            return false;
        }
        if (out1.getData() == null) {
            return false;
        }
        byte[] txdata = out1.getData();
        return this.dataHandler.isOurs(txdata);
    }

    List<UTXO> listLockedAndUnlockedUnspent(Wallet.Address addr, boolean locked, boolean unlocked) {
        Wallet wallet = this.cntmgr.getBlockchain().getWallet();
        ArrayList<UTXO> result = new ArrayList<UTXO>();
        if (unlocked) {
            result.addAll(wallet.listUnspent(Arrays.asList(addr)));
        }
        if (locked) {
            result.addAll(wallet.listLockUnspent(Arrays.asList(addr)));
        }
        return result;
    }

    Wallet.Address assertAddress(String rawAddr) {
        Wallet wallet = this.cntmgr.getBlockchain().getWallet();
        Wallet.Address addrs = wallet.findAddress(rawAddr);
        AssertState.assertNotNull((Object)addrs, (String)("Address not known to this wallet: " + rawAddr));
        return addrs;
    }

    private List<Multihash> getCids(List<T> fhandles) {
        List<Multihash> result = fhandles.stream().map(fh -> fh.getCid()).collect(Collectors.toList());
        return result;
    }

    private List<T> getMissingHandles(List<T> fhandles, Class<T> type) {
        List<Multihash> cids = this.getCids(fhandles);
        List result = this.getCurrentHandles(cids, type).stream().filter(fh -> cids.contains(fh.getCid())).filter(fh -> fh.isMissing()).collect(Collectors.toList());
        return result;
    }

    private List<T> getCurrentHandles(List<Multihash> cids, Class<T> type) {
        IPFSCache ipfsCache = this.cntmgr.getIPFSCache();
        List result = ipfsCache.getAll(type).stream().filter(fh -> cids.contains(fh.getCid())).collect(Collectors.toList());
        return result;
    }

    private String getLogPrefix(Class<T> type) {
        boolean isAddr = type == AHandle.class;
        return isAddr ? "IPFS Addr" : "IPFS";
    }

    class Executor {
        final Set<Multihash> scheduled = new HashSet<Multihash>();

        Executor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Future<Integer> process(final Wallet.Address owner, List<T> handles, final WorkerFactory<T> factory, long timeout) {
            List unscheduled;
            final Class type = factory.getType();
            String prefix = AbstractHandleManager.this.getLogPrefix(type);
            final List missing = AbstractHandleManager.this.getMissingHandles(handles, type);
            Set<Multihash> set = this.scheduled;
            synchronized (set) {
                unscheduled = this.getUnscheduledHandles(missing);
                this.scheduled.addAll(AbstractHandleManager.this.getCids(unscheduled));
            }
            if (missing.size() > 0) {
                AbstractHandleManager.this.LOG.info("{} finding: [utxo={}, missing={}, schedule={}]", new Object[]{prefix, handles.size(), missing.size(), unscheduled.size()});
            }
            final long shortNap = 500L;
            for (final AbstractHandle fh : unscheduled) {
                final Multihash cid = fh.getCid();
                AbstractHandleManager.this.LOG.info("{} submit: {}", (Object)prefix, (Object)fh);
                executorService.submit(new Callable<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean call() throws Exception {
                        try {
                            Future submit = null;
                            Object aux = AbstractHandleManager.this.getUnspentHandle(owner, cid, type);
                            while (aux != null && ((AbstractHandle)aux).isMissing()) {
                                if (submit == null || submit.isDone()) {
                                    Callable worker = factory.newWorker(aux);
                                    submit = executorService.submit(worker);
                                }
                                try {
                                    Thread.sleep(shortNap);
                                }
                                catch (InterruptedException e) {
                                    break;
                                }
                                aux = AbstractHandleManager.this.getUnspentHandle(owner, cid, type);
                            }
                        }
                        finally {
                            Set<Multihash> set = Executor.this.scheduled;
                            synchronized (set) {
                                Executor.this.scheduled.remove(cid);
                            }
                        }
                        return fh.isAvailable();
                    }
                });
            }
            Future<Integer> future = executorService.submit(new Callable<Integer>(){
                Map<Multihash, Integer> attempts = new HashMap<Multihash, Integer>();

                @Override
                public Integer call() throws Exception {
                    missing.forEach(fh -> this.attempts.put(fh.getCid(), fh.getAttempt()));
                    while (!this.completed()) {
                        try {
                            Thread.sleep(shortNap);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    List todos = AbstractHandleManager.this.getMissingHandles(missing, type);
                    return todos.size();
                }

                boolean completed() {
                    List todos = AbstractHandleManager.this.getMissingHandles(missing, type);
                    if (!todos.isEmpty()) {
                        todos = todos.stream().filter(fh -> {
                            int currAtt;
                            IPFSCache ipfsCache = AbstractHandleManager.this.cntmgr.getIPFSCache();
                            Object fhaux = ipfsCache.get(fh.getCid(), type);
                            int lastAtt = this.attempts.get(fh.getCid());
                            return lastAtt == (currAtt = ((AbstractHandle)fhaux).getAttempt());
                        }).collect(Collectors.toList());
                    }
                    return todos.isEmpty();
                }
            });
            return future;
        }

        private List<T> getUnscheduledHandles(List<T> fhandles) {
            List result = fhandles.stream().filter(fh -> !this.scheduled.contains(fh.getCid())).collect(Collectors.toList());
            return result;
        }
    }

    static interface WorkerFactory<T extends AbstractHandle> {
        public Class<T> getType();

        public Callable<T> newWorker(T var1);
    }
}

