/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.core;

import io.ipfs.multihash.Multihash;
import io.nessus.AbstractWallet;
import io.nessus.Blockchain;
import io.nessus.Network;
import io.nessus.RpcClientSupport;
import io.nessus.Tx;
import io.nessus.TxOutput;
import io.nessus.UTXO;
import io.nessus.Wallet;
import io.nessus.cipher.AESCipher;
import io.nessus.cipher.RSACipher;
import io.nessus.cipher.utils.AESUtils;
import io.nessus.cipher.utils.RSAUtils;
import io.nessus.ipfs.AHandle;
import io.nessus.ipfs.ContentManager;
import io.nessus.ipfs.ContentManagerConfig;
import io.nessus.ipfs.FHandle;
import io.nessus.ipfs.IPFSClient;
import io.nessus.ipfs.IPFSTimeoutException;
import io.nessus.ipfs.NessusUserFault;
import io.nessus.ipfs.core.AHandleManager;
import io.nessus.ipfs.core.FHandleManager;
import io.nessus.ipfs.core.FHeader;
import io.nessus.ipfs.core.FHeaderValues;
import io.nessus.ipfs.core.IPFSCache;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import io.nessus.utils.FileUtils;
import io.nessus.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public class DefaultContentManager
implements ContentManager {
    static final Logger LOG = LoggerFactory.getLogger(DefaultContentManager.class);
    protected final ContentManagerConfig config;
    protected final IPFSClient ipfsClient;
    protected final Blockchain blockchain;
    protected final Network network;
    protected final Wallet wallet;
    protected final FHeaderValues fhvals;
    protected final AHandleManager ahmgr;
    protected final FHandleManager fhmgr;
    private final IPFSCache ipfsCache = new IPFSCache();

    public DefaultContentManager(ContentManagerConfig config) {
        this.config = config;
        this.ipfsClient = config.getIPFSClient();
        this.blockchain = config.getBlockchain();
        this.network = this.blockchain.getNetwork();
        this.wallet = this.blockchain.getWallet();
        this.fhvals = this.getFHeaderValues();
        this.ahmgr = new AHandleManager(this);
        this.fhmgr = new FHandleManager(this);
        LOG.info("{}{}", (Object)this.getClass().getSimpleName(), (Object)config);
    }

    public DefaultContentManager(IPFSClient ipfsClient, Blockchain blockchain, ContentManagerConfig config) {
        this.ipfsClient = ipfsClient;
        this.blockchain = blockchain;
        this.config = config;
        this.network = blockchain.getNetwork();
        this.wallet = blockchain.getWallet();
        this.fhvals = this.getFHeaderValues();
        this.ahmgr = new AHandleManager(this);
        this.fhmgr = new FHandleManager(this);
    }

    public ContentManagerConfig getConfig() {
        return this.config;
    }

    @Override
    public Blockchain getBlockchain() {
        return this.blockchain;
    }

    @Override
    public IPFSClient getIPFSClient() {
        return this.ipfsClient;
    }

    public IPFSCache getIPFSCache() {
        return this.ipfsCache;
    }

    public AHandleManager getAHandleManager() {
        return this.ahmgr;
    }

    public FHandleManager getFHandleManager() {
        return this.fhmgr;
    }

    @Override
    public AHandle registerAddress(Wallet.Address owner) throws GeneralSecurityException, IOException {
        AHandle ahandle = this.registerAddress(owner, false);
        return ahandle;
    }

    public AHandle registerAddress(Wallet.Address owner, boolean dryRun) throws GeneralSecurityException, IOException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        this.assertArgumentHasLabel(owner);
        this.assertArgumentHasPrivateKey(owner);
        this.assertArgumentNotChangeAddress(owner);
        AHandle ahandle = this.findAddressRegistation(owner, null);
        if (ahandle != null && ahandle.isAvailable()) {
            return ahandle;
        }
        KeyPair keyPair = RSAUtils.newKeyPair((Wallet.Address)owner);
        PublicKey pubKey = keyPair.getPublic();
        ahandle = new AHandle.AHBuilder(owner, pubKey).build();
        ahandle = this.ahmgr.addIpfsContent(ahandle, dryRun);
        Multihash cid = ahandle.getCid();
        byte[] data = this.ahmgr.createAddrData(cid);
        Network network = this.getBlockchain().getNetwork();
        Wallet wallet = this.getBlockchain().getWallet();
        BigDecimal dustAmount = network.getDustThreshold();
        BigDecimal feePerKB = network.estimateSmartFee(null);
        BigDecimal dataAmount = dustAmount.multiply(BigDecimal.TEN);
        BigDecimal spendAmount = dataAmount.add(network.getMinDataAmount());
        String label = ahandle.getLabel();
        List utxos = wallet.selectUnspent(label, spendAmount.add(feePerKB));
        BigDecimal utxosAmount = this.getUTXOAmount(utxos);
        Wallet.Address changeAddr = wallet.getChangeAddress(label);
        BigDecimal changeAmount = utxosAmount.subtract(spendAmount.add(feePerKB));
        ArrayList<TxOutput> outputs = new ArrayList<TxOutput>();
        if (dustAmount.compareTo(changeAmount) < 0) {
            outputs.add(new TxOutput(changeAddr.getAddress(), changeAmount));
        }
        outputs.add(new TxOutput(owner.getAddress(), dataAmount, data));
        Tx tx = new Tx.TxBuilder().unspentInputs(utxos).outputs(outputs).build();
        String txId = wallet.sendTx(tx);
        LOG.info("Register PubKey: {} => Tx {} => {}", new Object[]{owner.getAddress(), txId, cid});
        tx = wallet.getTransaction(txId);
        int vout = tx.outputs().size() - 2;
        TxOutput dataOut = (TxOutput)tx.outputs().get(vout);
        AssertState.assertEquals((Object)owner.getAddress(), (Object)dataOut.getAddress());
        AssertState.assertEquals((Object)dataAmount, (Object)dataOut.getAmount());
        List<UTXO> unlocked = this.ahmgr.listLockedAndUnlockedUnspent(owner, false, true);
        unlocked.stream().filter(utxo -> utxo.getTxId().equals(txId)).filter(utxo -> utxo.getVout() == vout).forEach(utxo -> wallet.lockUnspent(utxo, false));
        LOG.debug("Redeem change: {}", (Object)changeAmount);
        ((AbstractWallet)wallet).redeemChange(label, owner);
        AHandle ahres = ((AHandle.AHBuilder)new AHandle.AHBuilder(ahandle).txId(tx.txId())).build();
        this.ipfsCache.put(ahres);
        return ahandle;
    }

    @Override
    public AHandle unregisterAddress(Wallet.Address owner) {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        this.assertArgumentHasLabel(owner);
        AHandle ahandle = this.findAddressRegistation(owner, null);
        if (ahandle == null) {
            return null;
        }
        Wallet wallet = this.getBlockchain().getWallet();
        List<UTXO> utxos = wallet.listLockUnspent(Arrays.asList(owner)).stream().filter(utxo -> this.ahmgr.isOurs(wallet.getTransaction(utxo.getTxId()))).peek(utxo -> wallet.lockUnspent(utxo, true)).collect(Collectors.toList());
        utxos = this.addMoreUtxoIfRequired(owner, utxos);
        String changeAddr = wallet.getChangeAddress((String)owner.getLabels().get(0)).getAddress();
        String txId = wallet.sendToAddress(changeAddr, changeAddr, Wallet.ALL_FUNDS, utxos);
        if (txId == null) {
            LOG.warn("Cannot unregister PubKey: {} => {}", (Object)owner, (Object)ahandle);
            return ahandle;
        }
        Multihash cid = ahandle.getCid();
        LOG.info("Unregister PubKey: {} => Tx {} => {}", new Object[]{owner.getAddress(), txId, cid});
        AHandle ahres = new AHandle.AHBuilder(ahandle).pubKey(null).build();
        return ahres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Multihash> unregisterIpfsContent(Wallet.Address owner, List<Multihash> cids) throws IOException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        this.assertArgumentHasLabel(owner);
        ArrayList<Multihash> results = new ArrayList<Multihash>();
        Wallet wallet = this.getBlockchain().getWallet();
        List<UTXO> utxos = wallet.listLockUnspent(Arrays.asList(owner)).stream().filter(utxo -> {
            FHandle fh = this.fhmgr.getHandleFromTx(owner, (UTXO)utxo);
            if (fh == null) {
                return false;
            }
            if (cids == null || cids.contains(fh.getCid())) {
                results.add(fh.getCid());
                return true;
            }
            return false;
        }).peek(utxo -> wallet.lockUnspent(utxo, true)).collect(Collectors.toList());
        utxos = this.addMoreUtxoIfRequired(owner, utxos);
        String changeAddr = wallet.getChangeAddress((String)owner.getLabels().get(0)).getAddress();
        String txId = wallet.sendToAddress(changeAddr, changeAddr, Wallet.ALL_FUNDS, utxos);
        if (txId == null) {
            LOG.warn("Cannot unregister IPFS: {} => {}", (Object)owner, results);
            return results;
        }
        IPFSCache iPFSCache = this.ipfsCache;
        synchronized (iPFSCache) {
            results.forEach(cid -> {
                LOG.info("Unregister IPFS: {} => {}", cid, (Object)txId);
                this.ipfsCache.remove((Multihash)cid, FHandle.class);
            });
        }
        return results;
    }

    @Override
    public FHandle addIpfsContent(Wallet.Address owner, Path path, URL srcUrl) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)path, (String)"Null path");
        AssertArgument.assertNotNull((Object)srcUrl, (String)"Null srcUrl");
        return this.addIpfsContent(owner, path, srcUrl.openStream());
    }

    @Override
    public FHandle addIpfsContent(Wallet.Address owner, Path dstPath, InputStream input) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)dstPath, (String)"Null path");
        AssertArgument.assertNotNull((Object)input, (String)"Null input");
        return this.addIpfsContent(owner, dstPath, input, false);
    }

    public FHandle addIpfsContent(Wallet.Address owner, Path dstPath, InputStream input, boolean dryRun) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)dstPath, (String)"Null path");
        AssertArgument.assertNotNull((Object)input, (String)"Null input");
        this.assertArgumentHasPrivateKey(owner);
        boolean fileOverwrite = this.config.isOverwrite();
        Path plainPath = this.assertValidPlainPath(owner, dstPath, false);
        NessusUserFault.assertTrue(fileOverwrite || !plainPath.toFile().exists(), "Local content already exists: " + dstPath);
        this.mkdirs(plainPath.getParent());
        Files.copy(input, plainPath, StandardCopyOption.REPLACE_EXISTING);
        return this.addIpfsContent(owner, dstPath, dryRun);
    }

    @Override
    public FHandle addIpfsContent(Wallet.Address owner, Path srcPath) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)srcPath, (String)"Null srcPath");
        return this.addIpfsContent(owner, srcPath, false);
    }

    public FHandle addIpfsContent(Wallet.Address owner, Path srcPath, boolean dryRun) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)srcPath, (String)"Null srcPath");
        this.assertArgumentHasPrivateKey(owner);
        PublicKey pubKey = this.assertAddressRegistration(owner);
        LOG.info("Start IPFS Add: {} {}", (Object)owner, (Object)srcPath);
        FHandle fhandle = this.buildTreeFromPath(owner, srcPath);
        LOG.info("IPFS encrypt: {}", (Object)fhandle.toString(true));
        fhandle = this.encrypt(owner, fhandle, pubKey);
        LOG.info("IPFS add: {}", (Object)fhandle.toString(true));
        Path tmpPath = fhandle.getFilePath();
        AssertState.assertTrue((Boolean)tmpPath.toFile().exists(), (String)("Encrypted content does not exists: " + tmpPath));
        fhandle = this.fhmgr.addIpfsContent(fhandle, dryRun);
        AssertState.assertNotNull((Object)fhandle.getCid(), (String)"No ipfs content ids");
        Multihash cid = fhandle.getCid();
        Path fullPath = this.getCryptPath(owner).resolve(cid.toBase58());
        FileUtils.atomicMove((Path)tmpPath, (Path)fullPath);
        URL furl = fullPath.toUri().toURL();
        FHandle fhres = this.fhmgr.getUnspentHandle(owner, cid, FHandle.class);
        if (fhres != null) {
            if (!fhres.isAvailable()) {
                fhres = new FHandle.FHBuilder(fhres).url(furl).build();
                fhres = this.fhmgr.createFHandleTree(fhres);
            }
            LOG.info("IPFS duplicate: {}", (Object)fhres);
        } else {
            fhres = ((FHandle.FHBuilder)new FHandle.FHBuilder(fhandle).url(furl).cid(cid)).build();
            LOG.info("IPFS record: {}", (Object)fhres);
            fhres = this.recordFileData(owner, fhres);
        }
        fhres = FHandle.FHWalker.walkTree(fhres, new FHandle.FHWalker.Visitor(){

            @Override
            public FHandle visit(FHandle fhaux) throws IOException {
                Path path = fhaux.getPath();
                FHandle fhroot = fhaux.getRoot();
                Path rootPath = fhroot.getFilePath();
                Path relPath = fhroot.getPath().relativize(path);
                Path fullPath = rootPath.resolve(relPath);
                URL furl = fullPath.toUri().toURL();
                FHandle fhres = new FHandle.FHBuilder(fhroot).findChild(path).available(true).url(furl).build();
                return fhres;
            }
        });
        this.ipfsCache.put(fhres);
        LOG.info("Done IPFS Add: {}", (Object)fhres.toString(true));
        return fhres;
    }

    public FHandle buildTreeFromPath(final Wallet.Address owner, final Path path) throws IOException {
        final Path plainPath = this.assertValidPlainPath(owner, path, false);
        AssertState.assertTrue((Boolean)plainPath.toFile().exists(), (String)("Local content does not exists: " + plainPath));
        boolean isDirectory = plainPath.toFile().isDirectory();
        final Path rootPath = isDirectory ? plainPath.getParent() : plainPath;
        final ArrayList fhandles = new ArrayList();
        final Stack fhstack = new Stack();
        Files.walkFileTree(plainPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FHandle fhandle = this.createFHandle(dir);
                fhandles.add(fhandle);
                fhstack.push(fhandle);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                fhstack.pop();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FHandle fhandle = this.createFHandle(file);
                fhandles.add(fhandle);
                return FileVisitResult.CONTINUE;
            }

            FHandle createFHandle(Path fullPath) throws IOException {
                FHandle parent = !fhstack.isEmpty() ? (FHandle)fhstack.peek() : null;
                URL furl = fullPath.toFile().toURI().toURL();
                boolean isDirectory = plainPath.toFile().isDirectory();
                Path relPath = isDirectory ? rootPath.relativize(fullPath) : path;
                FHandle fhres = new FHandle.FHBuilder(owner, relPath, furl).parent(parent).available(true).build();
                return fhres;
            }
        });
        AssertState.assertTrue((Boolean)(!fhandles.isEmpty() ? 1 : 0), (String)("Cannot obtain fhandle for: " + path));
        FHandle fhres = (FHandle)fhandles.get(0);
        return fhres;
    }

    @Override
    public FHandle getIpfsContent(Wallet.Address owner, Multihash cid, Path path, Long timeout) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)cid, (String)"Null cid");
        this.assertArgumentHasPrivateKey(owner);
        LOG.info("Start IPFS Get: {} {}", (Object)owner, (Object)cid);
        timeout = timeout != null ? timeout.longValue() : this.config.getIpfsTimeout();
        FHandle fhandle = this.ipfsGet(owner, cid, timeout);
        LOG.info("IPFS decrypt: {}", (Object)fhandle);
        fhandle = this.decrypt(fhandle, path, true);
        LOG.info("Done IPFS Get: {}", (Object)fhandle);
        return fhandle;
    }

    @Override
    public FHandle sendIpfsContent(Wallet.Address owner, Multihash cid, Wallet.Address toAddr, Long timeout) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)toAddr, (String)"Null toAddr");
        AssertArgument.assertNotNull((Object)cid, (String)"Null cid");
        this.assertArgumentHasLabel(owner);
        this.assertArgumentHasPrivateKey(owner);
        this.assertArgumentNotChangeAddress(owner);
        PublicKey pubKey = this.assertAddressRegistration(toAddr);
        LOG.info("Start IPFS Send: {} {} => {}", new Object[]{owner, cid, toAddr});
        timeout = timeout != null ? timeout.longValue() : this.config.getIpfsTimeout();
        FHandle fhandle = this.ipfsGet(owner, cid, timeout);
        LOG.info("IPFS decrypt: {}", (Object)fhandle.toString(true));
        fhandle = this.decrypt(fhandle, null, false);
        FHandle fhres = ((FHandle.FHBuilder)((FHandle.FHBuilder)new FHandle.FHBuilder(fhandle).secretToken(null).owner(toAddr)).cid(null)).build();
        LOG.info("IPFS encrypt: {}", (Object)fhres);
        fhres = this.encrypt(owner, fhres, pubKey);
        Path tmpPath = fhres.getFilePath();
        LOG.info("IPFS add: {}", (Object)fhres.toString(true));
        fhres = this.fhmgr.addIpfsContent(fhres, false);
        Path cryptPath = this.getCryptPath(toAddr).resolve(cid.toBase58());
        FileUtils.atomicMove((Path)tmpPath, (Path)cryptPath);
        URL furl = cryptPath.toUri().toURL();
        fhres = new FHandle.FHBuilder(fhres).url(furl).build();
        LOG.info("IPFS record: {}", (Object)fhres.toString(true));
        fhres = this.recordFileData(owner, fhres);
        LOG.info("Done IPFS Send: {}", (Object)fhres.toString(true));
        return fhres;
    }

    @Override
    public AHandle findAddressRegistation(Wallet.Address owner, Long timeout) {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        timeout = timeout != null ? timeout.longValue() : this.config.getIpfsTimeout();
        AHandle ahandle = this.ahmgr.findContentAsync(owner, timeout);
        return ahandle;
    }

    @Override
    public List<FHandle> findIpfsContent(Wallet.Address owner, Long timeout) throws IOException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        timeout = timeout != null ? timeout.longValue() : this.config.getIpfsTimeout();
        List<FHandle> fhandles = this.fhmgr.findContentAsync(owner, timeout);
        return fhandles;
    }

    @Override
    public List<FHandle> findLocalContent(Wallet.Address owner) throws IOException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        ArrayList<FHandle> fhandles = new ArrayList<FHandle>();
        Path plainPath = this.getPlainPath(owner);
        if (plainPath.toFile().exists()) {
            for (File file : plainPath.toFile().listFiles()) {
                Path path = plainPath.relativize(file.toPath());
                fhandles.add(this.findLocalContent(owner, path));
            }
        }
        return fhandles;
    }

    @Override
    public FHandle findLocalContent(Wallet.Address owner, Path path) throws IOException {
        FHandle fhres;
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)path, (String)"Null path");
        Path plainPath = this.getPlainPath(owner).resolve(path);
        if (!plainPath.toFile().exists()) {
            return null;
        }
        if (plainPath.toFile().isDirectory()) {
            fhres = this.buildTreeFromPath(owner, path);
        } else {
            URL furl = plainPath.toUri().toURL();
            fhres = new FHandle.FHBuilder(owner, path, furl).available(true).build();
        }
        return fhres;
    }

    @Override
    public InputStream getLocalContent(Wallet.Address owner, Path path) throws IOException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)path, (String)"Null path");
        Path plainPath = this.assertValidPlainPath(owner, path, false);
        if (!plainPath.toFile().isFile()) {
            return null;
        }
        return new FileInputStream(plainPath.toFile());
    }

    @Override
    public boolean removeLocalContent(Wallet.Address owner, Path path) throws IOException {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        path = path != null ? path : Paths.get("", new String[0]);
        Path plainPath = this.assertValidPlainPath(owner, path, true);
        boolean removed = FileUtils.recursiveDelete((Path)plainPath);
        AssertState.assertTrue((Boolean)removed, (String)("Cannot remove: " + plainPath));
        for (Path parent = plainPath.getParent(); parent != null && !this.getPlainPath(owner).equals(parent); parent = parent.getParent()) {
            String[] childfiles = parent.toFile().list();
            if (childfiles == null || childfiles.length != 0) continue;
            removed = FileUtils.recursiveDelete((Path)parent);
            AssertState.assertTrue((Boolean)removed, (String)("Cannot remove: " + parent));
        }
        return !path.toFile().exists();
    }

    public BitcoindRpcClient getBitcoinRpcClient() {
        return ((RpcClientSupport)this.blockchain).getRpcClient();
    }

    public FHeaderValues getFHeaderValues() {
        return new FHeaderValues("Nessus", "1.0");
    }

    public Path getRootPath() {
        Path rootPath = this.config.getDataDir();
        return this.mkdirs(rootPath);
    }

    public Path getPlainPath(Wallet.Address owner) {
        Path plainPath = this.getRootPath().resolve("plain").resolve(owner.getAddress());
        return this.mkdirs(plainPath);
    }

    public Path getCryptPath(Wallet.Address owner) {
        Path cryptPath = this.getRootPath().resolve("crypt").resolve(owner.getAddress());
        return this.mkdirs(cryptPath);
    }

    public Path getTempPath() {
        Path tmpPath = this.getRootPath().resolve("tmp");
        return this.mkdirs(tmpPath);
    }

    private Path createTempDir() throws IOException {
        return Files.createTempDirectory(this.getTempPath(), "", new FileAttribute[0]);
    }

    private FHandle ipfsGet(Wallet.Address owner, Multihash cid, long timeout) throws IOException, IPFSTimeoutException {
        FHandle fhandle = this.fhmgr.getUnspentHandle(owner, cid, FHandle.class);
        if (fhandle == null) {
            return null;
        }
        if (!fhandle.isAvailable()) {
            fhandle = this.fhmgr.getIpfsContent(fhandle, timeout);
        }
        return fhandle;
    }

    private FHandle recordFileData(Wallet.Address owner, FHandle fhandle) throws GeneralSecurityException {
        AssertArgument.assertTrue((Boolean)fhandle.isEncrypted(), (String)("File not encrypted: " + fhandle));
        byte[] data = this.fhmgr.createFileData(fhandle);
        BigDecimal dustAmount = this.network.getDustThreshold();
        BigDecimal feePerKB = this.network.estimateSmartFee(null);
        BigDecimal dataAmount = dustAmount.multiply(BigDecimal.TEN);
        BigDecimal spendAmount = dataAmount.add(this.network.getMinDataAmount());
        String label = (String)owner.getLabels().get(0);
        List utxos = this.wallet.selectUnspent(label, spendAmount.add(feePerKB));
        BigDecimal utxosAmount = this.getUTXOAmount(utxos);
        Wallet.Address changeAddr = this.wallet.getChangeAddress(label);
        BigDecimal changeAmount = utxosAmount.subtract(spendAmount.add(feePerKB));
        ArrayList<TxOutput> outputs = new ArrayList<TxOutput>();
        if (dustAmount.compareTo(changeAmount) < 0) {
            outputs.add(new TxOutput(changeAddr.getAddress(), changeAmount));
        }
        Wallet.Address toAddr = fhandle.getOwner();
        outputs.add(new TxOutput(toAddr.getAddress(), dataAmount, data));
        Tx tx = new Tx.TxBuilder().unspentInputs(utxos).outputs(outputs).build();
        String txId = this.wallet.sendTx(tx);
        if (toAddr.getPrivKey() != null) {
            tx = this.wallet.getTransaction(txId);
            int vout = tx.outputs().size() - 2;
            TxOutput dataOut = (TxOutput)tx.outputs().get(vout);
            AssertState.assertEquals((Object)toAddr.getAddress(), (Object)dataOut.getAddress());
            AssertState.assertEquals((Object)dataAmount, (Object)dataOut.getAmount());
            List<UTXO> unlocked = this.fhmgr.listLockedAndUnlockedUnspent(owner, false, true);
            unlocked.stream().filter(utxo -> utxo.getTxId().equals(txId)).filter(utxo -> utxo.getVout() == vout).forEach(utxo -> this.wallet.lockUnspent(utxo, false));
        }
        LOG.debug("Redeem change: {}", (Object)changeAmount);
        ((AbstractWallet)this.wallet).redeemChange(label, owner);
        fhandle = ((FHandle.FHBuilder)new FHandle.FHBuilder(fhandle).txId(txId)).build();
        return fhandle;
    }

    private BigDecimal getUTXOAmount(List<UTXO> utxos) {
        BigDecimal result = BigDecimal.ZERO;
        for (UTXO utxo : utxos) {
            result = result.add(utxo.getAmount());
        }
        return result;
    }

    private FHandle encrypt(final Wallet.Address owner, FHandle fhandle, PublicKey pubKey) throws IOException, GeneralSecurityException {
        AssertArgument.assertTrue((Boolean)(!fhandle.isEncrypted() ? 1 : 0), (String)("File already encrypted: " + fhandle));
        final AESCipher aes = new AESCipher();
        RSACipher rsa = new RSACipher();
        List<Multihash> cids = this.ipfsClient.add(fhandle.getFilePath(), true);
        AssertState.assertTrue((Boolean)(cids.size() > 0 ? 1 : 0), (String)("Cannot obtain content ids for: " + fhandle));
        Multihash cid = cids.get(cids.size() - 1);
        final SecretKey secKey = AESUtils.newSecretKey((Wallet.Address)owner, (Multihash)cid);
        byte[] tokBytes = rsa.encrypt(pubKey, secKey.getEncoded());
        final String secToken = Base64.getEncoder().encodeToString(tokBytes);
        final Wallet.Address toAddr = fhandle.getOwner();
        final Path tmpDir = this.createTempDir();
        FHandle fhres = FHandle.FHWalker.walkTree(fhandle, new FHandle.FHWalker.Visitor(){

            @Override
            public FHandle visit(FHandle fhaux) throws IOException, GeneralSecurityException {
                Path path = fhaux.getPath();
                Path tmpPath = tmpDir.resolve(path);
                DefaultContentManager.this.mkdirs(tmpPath.getParent());
                FHandle fhres = ((FHandle.FHBuilder)new FHandle.FHBuilder(fhaux.getRoot()).findChild(path).url(tmpPath.toUri().toURL()).secretToken(secToken).owner(toAddr)).build();
                if (fhres.hasChildren()) {
                    return fhres;
                }
                File srcFile = fhaux.getFilePath().toFile();
                AssertState.assertTrue((Boolean)srcFile.isFile(), (String)("Cannot obtain source file: " + srcFile));
                Multihash cid = DefaultContentManager.this.ipfsClient.addSingle(fhaux.getFilePath(), true);
                byte[] iv = AESUtils.getIV((Wallet.Address)owner, (Multihash)cid);
                try (FileWriter fw = new FileWriter(tmpPath.toFile());){
                    FHeader header = FHeader.fromFHandle(DefaultContentManager.this.fhvals, fhres);
                    header.write(fw);
                    try (FileInputStream ins = new FileInputStream(srcFile);){
                        InputStream encrypted = aes.encrypt(secKey, iv, (InputStream)ins, null);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        StreamUtils.copyStream((InputStream)encrypted, (OutputStream)baos);
                        String base64Encoded = Base64.getEncoder().encodeToString(baos.toByteArray());
                        fw.write(base64Encoded);
                    }
                    catch (GeneralSecurityException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                return fhres;
            }
        });
        return fhres;
    }

    public FHandle decrypt(FHandle fhandle, Path dstPath, boolean storePlain) throws IOException, GeneralSecurityException {
        AssertArgument.assertNotNull((Object)fhandle, (String)"Null fhandle");
        final AESCipher aes = new AESCipher();
        final RSACipher rsa = new RSACipher();
        Wallet.Address owner = fhandle.getOwner();
        KeyPair keyPair = RSAUtils.newKeyPair((Wallet.Address)owner);
        final PrivateKey privKey = keyPair.getPrivate();
        final Path tmpDir = this.createTempDir();
        FHandle fhres = FHandle.FHWalker.walkTree(fhandle, new FHandle.FHWalker.Visitor(){

            @Override
            public FHandle visit(FHandle fhandle) throws IOException {
                FHeader header;
                Path path = fhandle.getPath();
                Path tmpPath = tmpDir.resolve(path);
                DefaultContentManager.this.mkdirs(tmpPath.getParent());
                FHandle fhres = new FHandle.FHBuilder(fhandle.getRoot()).findChild(path).url(tmpPath.toUri().toURL()).build();
                if (fhandle.hasChildren()) {
                    return fhres;
                }
                File srcFile = fhandle.getFilePath().toFile();
                AssertState.assertTrue((Boolean)srcFile.isFile(), (String)("Cannot obtain source file: " + srcFile));
                try (FileReader fr = new FileReader(srcFile);){
                    header = FHeader.fromReader(DefaultContentManager.this.fhvals, fr);
                }
                try {
                    fr = new FileReader(srcFile);
                    var8_8 = null;
                    try {
                        for (int i = 0; i < header.length; ++i) {
                            fr.read();
                        }
                        byte[] encToken = Base64.getDecoder().decode(header.token);
                        byte[] token = rsa.decrypt(privKey, encToken);
                        SecretKey secKey = AESUtils.decodeSecretKey((byte[])token);
                        String base64Encoded = new BufferedReader(fr).readLine();
                        byte[] encBytes = Base64.getDecoder().decode(base64Encoded);
                        ByteArrayInputStream ins = new ByteArrayInputStream(encBytes);
                        InputStream decrypted = aes.decrypt(secKey, (InputStream)ins);
                        Path tmpFile = tmpDir.resolve(fhres.getPath());
                        DefaultContentManager.this.mkdirs(tmpFile.getParent());
                        Files.copy(decrypted, tmpFile, StandardCopyOption.REPLACE_EXISTING);
                        fhres = new FHandle.FHBuilder(fhres.getRoot()).findChild(path).url(tmpFile.toUri().toURL()).secretToken(null).build();
                    }
                    catch (Throwable throwable) {
                        var8_8 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fr != null) {
                            if (var8_8 != null) {
                                try {
                                    fr.close();
                                }
                                catch (Throwable throwable) {
                                    var8_8.addSuppressed(throwable);
                                }
                            } else {
                                fr.close();
                            }
                        }
                    }
                }
                catch (GeneralSecurityException ex) {
                    throw new IllegalStateException(ex);
                }
                return fhres;
            }
        });
        if (storePlain) {
            dstPath = dstPath != null ? dstPath : fhandle.getPath();
            AssertArgument.assertTrue((Boolean)(!dstPath.isAbsolute() ? 1 : 0), (String)("Given path must be relative: " + dstPath));
            boolean fileOverwrite = this.config.isOverwrite();
            Path plainPath = this.assertValidPlainPath(owner, dstPath, false);
            NessusUserFault.assertTrue(fileOverwrite || !plainPath.toFile().exists(), "Local content already exists: " + dstPath);
            Path tmpPath = fhres.getFilePath();
            this.mkdirs(plainPath.getParent());
            FileUtils.recursiveDelete((Path)plainPath);
            FileUtils.recursiveCopy((Path)tmpPath, (Path)plainPath);
            FileUtils.recursiveDelete((Path)tmpPath);
            FHandle fhaux = this.buildTreeFromPath(owner, dstPath);
            fhres = ((FHandle.FHBuilder)((FHandle.FHBuilder)new FHandle.FHBuilder(fhaux).attempt(fhres.getAttempt())).elapsed(fhres.getElapsed())).build();
        }
        return fhres;
    }

    private List<UTXO> addMoreUtxoIfRequired(Wallet.Address addr, List<UTXO> utxos) {
        BigDecimal amount = AbstractWallet.getUTXOAmount(utxos);
        if (amount.compareTo(this.network.getMinTxFee()) > 0) {
            return utxos;
        }
        ArrayList<UTXO> result = new ArrayList<UTXO>(utxos);
        LOG.info("Utxos amount: {}", (Object)amount);
        List unspent = this.wallet.listUnspent(Arrays.asList(addr));
        LOG.info("All unspent: {}", (Object)unspent);
        for (UTXO aux : unspent) {
            if (result.contains(aux)) continue;
            result.add(aux);
            amount = AbstractWallet.getUTXOAmount(result);
            LOG.info("Utxos amount: {}", (Object)amount);
            if (amount.compareTo(this.network.getMinTxFee()) <= 0) continue;
            break;
        }
        return result;
    }

    private Path mkdirs(Path path) {
        if (path.toFile().isDirectory()) {
            return path;
        }
        AssertState.assertFalse((Boolean)path.toFile().isFile(), (String)("File already exists: " + path));
        AssertState.assertTrue((Boolean)path.toFile().mkdirs(), (String)("Cannot create directory: " + path));
        return path;
    }

    private void assertArgumentHasPrivateKey(Wallet.Address addr) {
        AssertArgument.assertNotNull((Object)addr.getPrivKey(), (String)("Wallet does not control private key for: " + addr));
    }

    private void assertArgumentHasLabel(Wallet.Address addr) {
        AssertArgument.assertTrue((Boolean)(!addr.getLabels().isEmpty() ? 1 : 0), (String)("Address has no label: " + addr));
    }

    private void assertArgumentNotChangeAddress(Wallet.Address addr) {
        AssertArgument.assertTrue((Boolean)(!addr.getLabels().contains("(change)") ? 1 : 0), (String)("Cannot use change address: " + addr));
    }

    private PublicKey assertAddressRegistration(Wallet.Address addr) {
        AHandle ahandle = this.findAddressRegistation(addr, null);
        AssertArgument.assertTrue((Boolean)(ahandle != null && ahandle.isAvailable() ? 1 : 0), (String)("Cannot obtain encryption key for: " + addr));
        return ahandle.getPubKey();
    }

    private Path assertValidPlainPath(Wallet.Address owner, Path path, boolean allowEmpty) {
        AssertArgument.assertNotNull((Object)path, (String)"Null path");
        AssertArgument.assertTrue((Boolean)(!path.isAbsolute() ? 1 : 0), (String)("Not a relative path: " + path));
        String pstr = path.toString();
        AssertArgument.assertTrue((Boolean)(allowEmpty || pstr.trim().length() > 0 ? 1 : 0), (String)"Empty path");
        return this.getPlainPath(owner).resolve(path);
    }
}

