/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.core;

import io.ipfs.api.IPFS;
import io.ipfs.api.MerkleNode;
import io.ipfs.api.NamedStreamable;
import io.ipfs.multiaddr.MultiAddress;
import io.ipfs.multihash.Multihash;
import io.nessus.ipfs.IPFSClient;
import io.nessus.ipfs.IPFSException;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import io.nessus.utils.StreamUtils;
import io.nessus.utils.SystemUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIPFSClient
implements IPFSClient {
    static final Logger LOG = LoggerFactory.getLogger(DefaultIPFSClient.class);
    private final MultiAddress addr;
    private final IPFS ipfs;
    private final ExecutorService executorService;

    public DefaultIPFSClient() {
        this(SystemUtils.getenv((String)"IPFS_JSONRPC_ADDR", (String)"127.0.0.1"), Integer.parseInt(SystemUtils.getenv((String)"IPFS_JSONRPC_PORT", (String)"5001")));
    }

    public DefaultIPFSClient(String host, Integer port) {
        this(new MultiAddress("/ip4/" + host + "/tcp/" + port));
    }

    public DefaultIPFSClient(MultiAddress addr) {
        this.addr = addr;
        try {
            this.ipfs = new IPFS(addr);
        }
        catch (RuntimeException ex) {
            LOG.error("Cannot connect to: " + addr);
            throw ex;
        }
        this.executorService = Executors.newFixedThreadPool(12, new ThreadFactory(){
            AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable run) {
                return new Thread(run, "ipfs-client-" + this.count.incrementAndGet());
            }
        });
    }

    public IPFS getIpfs() {
        AssertState.assertNotNull((Object)this.ipfs, (String)"No IPFS connection");
        return this.ipfs;
    }

    @Override
    public IPFS.Config getIpfsConfig() {
        return this.getIpfs().config;
    }

    @Override
    public String getPeerId() throws IOException {
        return this.getIpfsConfig().get("Identity.PeerID");
    }

    @Override
    public MultiAddress getAPIAddress() {
        return this.addr;
    }

    @Override
    public boolean hasConnection() {
        return this.ipfs != null;
    }

    @Override
    public List<Multihash> add(Path path) throws IOException {
        return this.add(path, false);
    }

    @Override
    public List<Multihash> add(Path path, boolean hashOnly) throws IOException {
        List parts = this.getIpfs().add((NamedStreamable)new NamedStreamable.FileWrapper(path.toFile()), false, hashOnly);
        AssertState.assertTrue((Boolean)(parts.size() > 0 ? 1 : 0), (String)"No content added");
        return parts.stream().map(mn -> mn.hash).collect(Collectors.toList());
    }

    @Override
    public Multihash addSingle(Path path) throws IOException {
        return this.addSingle(path, false);
    }

    @Override
    public Multihash addSingle(Path path, boolean hashOnly) throws IOException {
        AssertArgument.assertTrue((Boolean)path.toFile().isFile(), (String)("Not a file: " + path));
        List<Multihash> cids = this.add(path, hashOnly);
        AssertState.assertTrue((Boolean)(cids.size() > 0 ? 1 : 0), (String)"No content added");
        return cids.get(0);
    }

    @Override
    public Multihash addSingle(InputStream input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return this.addSingle(baos.toByteArray());
    }

    @Override
    public Multihash addSingle(InputStream input, boolean hashOnly) throws IOException {
        return this.addSingle(input, false);
    }

    @Override
    public Multihash addSingle(byte[] bytes) throws IOException {
        return this.addSingle(bytes, false);
    }

    @Override
    public Multihash addSingle(byte[] bytes, boolean hashOnly) throws IOException {
        List parts = this.getIpfs().add((NamedStreamable)new NamedStreamable.ByteArrayWrapper(bytes), false, hashOnly);
        AssertState.assertTrue((Boolean)(parts.size() > 0 ? 1 : 0), (String)"No content added");
        Multihash cid = parts.stream().map(mn -> mn.hash).findFirst().get();
        return cid;
    }

    @Override
    public Future<InputStream> cat(final Multihash cid) throws IOException {
        Callable<InputStream> call = new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                try {
                    return DefaultIPFSClient.this.getIpfs().catStream(cid);
                }
                catch (Exception ex) {
                    throw new IPFSException(ex);
                }
            }
        };
        Future<InputStream> future = this.executorService.submit(call);
        return future;
    }

    @Override
    public Future<Path> get(final Multihash cid, final Path outdir) {
        Callable<Path> call = new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                try {
                    return this.getInternal(cid, outdir.resolve(cid.toBase58()));
                }
                catch (Exception ex) {
                    throw new IPFSException(ex);
                }
            }

            Path getInternal(Multihash cid2, Path outpath) throws IOException {
                List links = ((MerkleNode)DefaultIPFSClient.this.getIpfs().ls((Multihash)cid2).get((int)0)).links;
                for (MerkleNode node : links) {
                    String name = (String)node.name.get();
                    this.getInternal(node.hash, outpath.resolve(name));
                }
                if (links.isEmpty()) {
                    File outfile = outpath.toFile();
                    outpath.getParent().toFile().mkdirs();
                    try (FileOutputStream fout = new FileOutputStream(outfile);){
                        InputStream ins = DefaultIPFSClient.this.getIpfs().catStream(cid2);
                        StreamUtils.copyStream((InputStream)ins, (OutputStream)fout);
                    }
                }
                return outpath;
            }
        };
        Future<Path> future = this.executorService.submit(call);
        return future;
    }

    @Override
    public String version() throws IOException {
        return this.getIpfs().version();
    }
}

