/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonClient;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.impl.ProtonSaslClientAuthenticatorImpl;

public class ProtonClientImpl
implements ProtonClient {
    private final Vertx vertx;

    public ProtonClientImpl(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void connect(String host, int port, Handler<AsyncResult<ProtonConnection>> handler) {
        this.connect(host, port, null, null, handler);
    }

    @Override
    public void connect(String host, int port, String username, String password, Handler<AsyncResult<ProtonConnection>> handler) {
        this.connect(new ProtonClientOptions(), host, port, username, password, handler);
    }

    @Override
    public void connect(ProtonClientOptions options, String host, int port, Handler<AsyncResult<ProtonConnection>> handler) {
        this.connect(options, host, port, null, null, handler);
    }

    @Override
    public void connect(ProtonClientOptions options, String host, int port, String username, String password, Handler<AsyncResult<ProtonConnection>> handler) {
        NetClient netClient = this.vertx.createNetClient(options);
        this.connectNetClient(netClient, host, port, username, password, handler, options);
    }

    private void connectNetClient(NetClient netClient, String host, int port, String username, String password, Handler<AsyncResult<ProtonConnection>> connectHandler, ProtonClientOptions options) {
        netClient.connect(port, host, (AsyncResult<NetSocket> res) -> {
            if (res.succeeded()) {
                ProtonConnectionImpl amqpConnnection = new ProtonConnectionImpl(this.vertx, host);
                ProtonSaslClientAuthenticatorImpl authenticator = new ProtonSaslClientAuthenticatorImpl(username, password, options.getAllowedSaslMechanisms(), (NetSocket)res.result(), connectHandler, amqpConnnection);
                amqpConnnection.bindClient(netClient, (NetSocket)res.result(), authenticator);
                amqpConnnection.flush();
            } else {
                connectHandler.handle(Future.failedFuture(res.cause()));
            }
        });
    }
}

