/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonServer;
import io.vertx.proton.ProtonServerOptions;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.impl.ProtonSaslServerAuthenticatorImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.qpid.proton.amqp.Symbol;

public class ProtonServerImpl
implements ProtonServer {
    private final Vertx vertx;
    private final NetServer server;
    private Handler<ProtonConnection> handler;
    private boolean advertiseAnonymousRelayCapability = true;

    public ProtonServerImpl(Vertx vertx) {
        this.vertx = vertx;
        this.server = this.vertx.createNetServer();
    }

    public ProtonServerImpl(Vertx vertx, ProtonServerOptions options) {
        this.vertx = vertx;
        this.server = this.vertx.createNetServer(options);
    }

    @Override
    public int actualPort() {
        return this.server.actualPort();
    }

    @Override
    public ProtonServerImpl listen(int i) {
        this.server.listen(i);
        return this;
    }

    @Override
    public ProtonServerImpl listen() {
        this.server.listen();
        return this;
    }

    public boolean isMetricsEnabled() {
        return this.server.isMetricsEnabled();
    }

    @Override
    public ProtonServerImpl listen(int port, String host, Handler<AsyncResult<ProtonServer>> handler) {
        this.server.listen(port, host, this.convertHandler(handler));
        return this;
    }

    @Override
    public ProtonServerImpl listen(Handler<AsyncResult<ProtonServer>> handler) {
        this.server.listen(this.convertHandler(handler));
        return this;
    }

    private Handler<AsyncResult<NetServer>> convertHandler(Handler<AsyncResult<ProtonServer>> handler) {
        return result -> {
            if (result.succeeded()) {
                handler.handle(Future.succeededFuture(this));
            } else {
                handler.handle(Future.failedFuture(result.cause()));
            }
        };
    }

    @Override
    public ProtonServerImpl listen(int i, String s) {
        this.server.listen(i, s);
        return this;
    }

    @Override
    public ProtonServerImpl listen(int i, Handler<AsyncResult<ProtonServer>> handler) {
        this.server.listen(i, this.convertHandler(handler));
        return this;
    }

    @Override
    public void close() {
        this.server.close();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.server.close(handler);
    }

    @Override
    public Handler<ProtonConnection> connectHandler() {
        return this.handler;
    }

    @Override
    public ProtonServerImpl connectHandler(final Handler<ProtonConnection> handler) {
        this.handler = handler;
        this.server.connectHandler(new Handler<NetSocket>(){

            @Override
            public void handle(NetSocket netSocket) {
                String hostname = null;
                try {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                ProtonConnectionImpl connection = new ProtonConnectionImpl(ProtonServerImpl.this.vertx, hostname);
                if (ProtonServerImpl.this.advertiseAnonymousRelayCapability) {
                    connection.setOfferedCapabilities(new Symbol[]{ProtonConnectionImpl.ANONYMOUS_RELAY});
                }
                connection.bindServer(netSocket, new ProtonSaslServerAuthenticatorImpl(handler, connection));
            }
        });
        return this;
    }

    public void setAdvertiseAnonymousRelayCapability(boolean advertiseAnonymousRelayCapability) {
        this.advertiseAnonymousRelayCapability = advertiseAnonymousRelayCapability;
    }
}

