/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.amqp;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonReceiver;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.message.Message;
import org.apache.spark.streaming.amqp.AMQPFlowController;
import org.apache.spark.streaming.amqp.AMQPFlowControllerListener;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\r5\u0011q#Q'R!\u0006\u001b\u0018P\\2GY><8i\u001c8ue>dG.\u001a:\u000b\u0005\r!\u0011\u0001B1ncBT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!AE!N#B3En\\<D_:$(o\u001c7mKJ\u00042a\u0005\u000e\u001d\u001b\u0005!\"BA\u000b\u0017\u0003\u0011\u0019wN]3\u000b\u0005]A\u0012!\u0002<feRD(\"A\r\u0002\u0005%|\u0017BA\u000e\u0015\u0005\u001dA\u0015M\u001c3mKJ\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t1\fgn\u001a\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0003M_:<\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0011I,7-Z5wKJ\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\f\u0002\rA\u0014x\u000e^8o\u0013\tY\u0003F\u0001\bQe>$xN\u001c*fG\u0016Lg/\u001a:\t\u00115\u0002!\u0011!Q\u0001\n9\n\u0001\u0002\\5ti\u0016tWM\u001d\t\u0003\u001f=J!\u0001\r\u0002\u00035\u0005k\u0015\u000b\u0015$m_^\u001cuN\u001c;s_2dWM\u001d'jgR,g.\u001a:\t\u0011I\u0002!\u0011!Q\u0001\nq\tq!\\1y%\u0006$X\r\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u00035!\t\u0019R'\u0003\u00027)\t)a+\u001a:uq\")\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"RAO\u001e={y\u0002\"a\u0004\u0001\t\u000b\u0015:\u0004\u0019\u0001\u0014\t\u000b5:\u0004\u0019\u0001\u0018\t\u000bI:\u0004\u0019\u0001\u000f\t\u000b]9\u0004\u0019\u0001\u001b\t\u000f\u0001\u0003\u0001\u0019!C\u0001\u0003\u0006)\u0011/^3vKV\t!\tE\u0002D\u00152k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bq!\\;uC\ndWM\u0003\u0002H\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013#\u0003\u000bE+X-^3\u0011\t5s\u0005kU\u0007\u0002\u0011&\u0011q\n\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u001d\n\u0016B\u0001*)\u00059\u0001&o\u001c;p]\u0012+G.\u001b<fef\u0004\"\u0001\u0016.\u000e\u0003US!AV,\u0002\u000f5,7o]1hK*\u0011\u0011\u0006\u0017\u0006\u00033\"\tA!\u001d9jI&\u00111,\u0016\u0002\b\u001b\u0016\u001c8/Y4f\u0011\u001di\u0006\u00011A\u0005\u0002y\u000b\u0011\"];fk\u0016|F%Z9\u0015\u0005}\u0013\u0007CA'a\u0013\t\t\u0007J\u0001\u0003V]&$\bbB2]\u0003\u0003\u0005\rAQ\u0001\u0004q\u0012\n\u0004BB3\u0001A\u0003&!)\u0001\u0004rk\u0016,X\r\t\u0005\bO\u0002\u0001\r\u0011\"\u0001i\u0003\u0011a\u0017m\u001d;\u0016\u0003qAqA\u001b\u0001A\u0002\u0013\u00051.\u0001\u0005mCN$x\fJ3r)\tyF\u000eC\u0004dS\u0006\u0005\t\u0019\u0001\u000f\t\r9\u0004\u0001\u0015)\u0003\u001d\u0003\u0015a\u0017m\u001d;!\u0011\u001d\u0001\bA1A\u0005\u0002E\f\u0001\u0003]3s[&$8\u000fU3s'\u0016\u001cwN\u001c3\u0016\u0003I\u0004\"!T:\n\u0005QD%A\u0002#pk\ndW\r\u0003\u0004w\u0001\u0001\u0006IA]\u0001\u0012a\u0016\u0014X.\u001b;t!\u0016\u00148+Z2p]\u0012\u0004\u0003b\u0002=\u0001\u0005\u0004%\t!]\u0001\u0015gR\f'\r\\3J]R,'O^1m\u001b&\u001c'o\\:\t\ri\u0004\u0001\u0015!\u0003s\u0003U\u0019H/\u00192mK&sG/\u001a:wC2l\u0015n\u0019:pg\u0002Bq\u0001 \u0001A\u0002\u0013\u0005Q0\u0001\buS6,'oU2iK\u0012,H.\u001a3\u0016\u0003y\u0004\"!T@\n\u0007\u0005\u0005\u0001JA\u0004C_>dW-\u00198\t\u0013\u0005\u0015\u0001\u00011A\u0005\u0002\u0005\u001d\u0011A\u0005;j[\u0016\u00148k\u00195fIVdW\rZ0%KF$2aXA\u0005\u0011!\u0019\u00171AA\u0001\u0002\u0004q\bbBA\u0007\u0001\u0001\u0006KA`\u0001\u0010i&lWM]*dQ\u0016$W\u000f\\3eA!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0011A\u00032fM>\u0014Xm\u00149f]R\tq\fC\u0004\u0002\u0018\u0001!\t%a\u0005\u0002\u0017\t,gm\u001c:f\u00072|7/\u001a\u0005\b\u00037\u0001A\u0011IA\u000f\u0003\u001d\t7-];je\u0016$RaXA\u0010\u0003GAq!!\t\u0002\u001a\u0001\u0007\u0001+\u0001\u0005eK2Lg/\u001a:z\u0011\u00191\u0016\u0011\u0004a\u0001'\"9\u0011q\u0005\u0001\u0005\n\u0005M\u0011!D:dQ\u0016$W\u000f\\3US6,'\u000fC\u0004\u0002,\u0001!\t%!\f\u0002\r!\fg\u000e\u001a7f)\ry\u0016q\u0006\u0005\b\u0003c\tI\u00031\u0001\u001d\u0003\u001d!\u0018.\\3s\u0013\u0012\u0004")
public final class AMQPAsyncFlowController
extends AMQPFlowController
implements Handler<Long> {
    private final Vertx vertx;
    private Queue<Tuple2<ProtonDelivery, Message>> queue;
    private Long last;
    private final double permitsPerSecond;
    private final double stableIntervalMicros;
    private boolean timerScheduled;

    public Queue<Tuple2<ProtonDelivery, Message>> queue() {
        return this.queue;
    }

    public void queue_$eq(Queue<Tuple2<ProtonDelivery, Message>> x$1) {
        this.queue = x$1;
    }

    public Long last() {
        return this.last;
    }

    public void last_$eq(Long x$1) {
        this.last = x$1;
    }

    public double permitsPerSecond() {
        return this.permitsPerSecond;
    }

    public double stableIntervalMicros() {
        return this.stableIntervalMicros;
    }

    public boolean timerScheduled() {
        return this.timerScheduled;
    }

    public void timerScheduled_$eq(boolean x$1) {
        this.timerScheduled = x$1;
    }

    @Override
    public void beforeOpen() {
        this.last_$eq(Predef$.MODULE$.long2Long(0L));
        this.timerScheduled_$eq(false);
        this.queue().clear();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AMQPAsyncFlowController $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"permitsPerSecond ", ", stableIntervalMicros ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.permitsPerSecond()), BoxesRunTime.boxToLong((long)TimeUnit.MICROSECONDS.toMillis((long)this.$outer.stableIntervalMicros()))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void beforeClose() {
    }

    @Override
    public void acquire(ProtonDelivery delivery, Message message) {
        Long now = Predef$.MODULE$.long2Long(TimeUnit.NANOSECONDS.toMicros(System.nanoTime()));
        if ((double)Predef$.MODULE$.Long2long(now) > (double)Predef$.MODULE$.Long2long(this.last()) + this.stableIntervalMicros() && this.queue().isEmpty()) {
            this.last_$eq(Predef$.MODULE$.long2Long(TimeUnit.NANOSECONDS.toMicros(System.nanoTime())));
            super.acquire(delivery, message);
        } else {
            this.logDebug((Function0<String>)new Serializable(this, delivery){
                public static final long serialVersionUID = 0L;
                private final ProtonDelivery delivery$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--> Enqueue delivery tag [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(this.delivery$2.getTag())}));
                }
                {
                    this.delivery$2 = delivery$2;
                }
            });
            this.queue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)delivery, (Object)message)}));
            this.scheduleTimer();
        }
    }

    private void scheduleTimer() {
        if (!this.timerScheduled()) {
            ObjectRef delay = ObjectRef.create((Object)Predef$.MODULE$.long2Long(TimeUnit.MICROSECONDS.toMillis((long)this.stableIntervalMicros())));
            if (BoxesRunTime.equalsNumObject((Number)((Long)delay.elem), (Object)BoxesRunTime.boxToInteger((int)0))) {
                delay.elem = Predef$.MODULE$.long2Long(1L);
            }
            this.logDebug((Function0<String>)new Serializable(this, delay){
                public static final long serialVersionUID = 0L;
                private final ObjectRef delay$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timer scheduled every ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Long)this.delay$1.elem}));
                }
                {
                    this.delay$1 = delay$1;
                }
            });
            this.vertx.setTimer(Predef$.MODULE$.Long2long((Long)delay.elem), this);
            this.timerScheduled_$eq(true);
        }
    }

    @Override
    public void handle(Long timerId) {
        this.timerScheduled_$eq(false);
        Tuple2 t = (Tuple2)this.queue().dequeue();
        this.logDebug((Function0<String>)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Tuple2 t$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<-- Dequeue delivery tag [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(((ProtonDelivery)this.t$1._1()).getTag())}));
            }
            {
                this.t$1 = t$1;
            }
        });
        this.last_$eq(Predef$.MODULE$.long2Long(TimeUnit.NANOSECONDS.toMicros(System.nanoTime())));
        super.acquire((ProtonDelivery)t._1(), (Message)t._2());
        if (!this.queue().isEmpty()) {
            this.scheduleTimer();
        }
    }

    public AMQPAsyncFlowController(ProtonReceiver receiver, AMQPFlowControllerListener listener, Long maxRate, Vertx vertx) {
        this.vertx = vertx;
        super(receiver, listener);
        this.queue = new Queue();
        this.last = Predef$.MODULE$.long2Long(0L);
        this.permitsPerSecond = Predef$.MODULE$.Long2long(maxRate);
        this.stableIntervalMicros = (double)TimeUnit.SECONDS.toMicros(1L) / this.permitsPerSecond();
        this.timerScheduled = false;
    }
}

