/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.amqp;

import org.apache.qpid.proton.message.Message;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.amqp.AMQPBodyFunction;
import org.apache.spark.streaming.amqp.AMQPInputDStream;
import org.apache.spark.streaming.amqp.JavaAMQPJsonFunction;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class AMQPUtils$ {
    public static final AMQPUtils$ MODULE$;

    static {
        new AMQPUtils$();
    }

    public <T> ReceiverInputDStream<T> createStream(StreamingContext ssc, String host, int port, String address, Function1<Message, Option<T>> messageConverter, StorageLevel storageLevel, ClassTag<T> evidence$1) {
        boolean walEnabled = WriteAheadLogUtils$.MODULE$.enableReceiverLog(ssc.conf());
        return new AMQPInputDStream<T>(ssc, host, port, address, messageConverter, walEnabled, storageLevel, evidence$1);
    }

    public <T> ReceiverInputDStream<T> createStream(StreamingContext ssc, String host, int port, String address, ClassTag<T> evidence$2) {
        return this.createStream(ssc, host, port, address, new AMQPBodyFunction(), StorageLevel$.MODULE$.MEMORY_ONLY(), evidence$2);
    }

    public <T> JavaReceiverInputDStream<T> createStream(JavaStreamingContext jssc, String host, int port, String address, Function<Message, Option<T>> messageConverter, StorageLevel storageLevel) {
        ClassTag cmt = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.AnyRef());
        boolean walEnabled = WriteAheadLogUtils$.MODULE$.enableReceiverLog(jssc.ssc().conf());
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(new AMQPInputDStream(jssc.ssc(), host, port, address, this.fn$1(messageConverter), walEnabled, storageLevel, cmt), cmt);
    }

    public JavaReceiverInputDStream<String> createStream(JavaStreamingContext jssc, String host, int port, String address) {
        JavaAMQPJsonFunction messageConverter = new JavaAMQPJsonFunction();
        return this.createStream(jssc, host, port, address, messageConverter, StorageLevel$.MODULE$.MEMORY_ONLY());
    }

    private final Function1 fn$1(Function messageConverter$1) {
        return new Serializable(messageConverter$1){
            public static final long serialVersionUID = 0L;
            private final Function messageConverter$1;

            public final Option<T> apply(Message x) {
                return (Option)this.messageConverter$1.call((Object)x);
            }
            {
                this.messageConverter$1 = messageConverter$1;
            }
        };
    }

    private AMQPUtils$() {
        MODULE$ = this;
    }
}

